/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.contributions;

public final class BundleVersion {
    private final int[] m_versions;

    private BundleVersion(int[] versions) {
        this.m_versions = (int[])versions.clone();
    }

    public BundleVersion(int major, int minor, int micro) {
        this(BundleVersion.createVersionArray(major, minor, micro));
    }

    private static int[] createVersionArray(int major, int minor, int micro) {
        int[] versions = new int[]{major, minor, micro};
        return versions;
    }

    public int getMajor() {
        return this.m_versions[0];
    }

    public int getMinor() {
        return this.m_versions[1];
    }

    public int getMicro() {
        return this.m_versions[2];
    }

    public BundleVersion createNextMajor() {
        return new BundleVersion(this.getMajor() + 1, this.getMinor(), this.getMicro());
    }

    public BundleVersion createNextMinor() {
        return new BundleVersion(this.getMajor(), this.getMinor() + 1, this.getMicro());
    }

    public BundleVersion createNextMicro() {
        return new BundleVersion(this.getMajor(), this.getMinor(), this.getMicro() + 1);
    }

    public static BundleVersion valueOf(String version) {
        String[] versions = version.split("\\.");
        int[] versionArray = new int[3];
        int n = 0;
        while (n < versions.length && n < versionArray.length) {
            versionArray[n] = Integer.parseInt(versions[n]);
            ++n;
        }
        return new BundleVersion(versionArray);
    }

    public String toString() {
        return String.valueOf(this.getMajor()) + "." + this.getMinor() + '.' + this.getMicro();
    }
}

