/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.custom;

import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnInput;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewConfigurer;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.custom.EventTableProviderRepository;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.LinkedHashMap;

public final class CustomTableConfigurer
extends ColumnViewConfigurer {
    public static final String DATA_PROVIDER = "dataProvider";

    @Override
    protected IInput createInput() {
        TabFolderInput tfi = new TabFolderInput();
        tfi.addInput(this.createGeneral());
        tfi.addInput(this.createColumns());
        return tfi;
    }

    private IInput createGeneral() {
        CompositeInput ci = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE);
        ci.addInput(InputFactory.createOperativeSetEnabled());
        ci.addInput(InputFactory.createRole(new Role[0]));
        ci.addInput(this.createDataProvider());
        ci.addInput(InputFactory.createIcon());
        return ci;
    }

    private IInput createColumns() {
        ColumnInput ci = new ColumnInput(this.getServiceLocator(), this.getRepository());
        ci.addInput(InputFactory.createEmphasized());
        ci.addInput(InputFactory.createVisible());
        ci.addInput(InputFactory.createFilter(this.getColumnDescriptors()));
        ci.addInput(InputFactory.createInitiallySorted(this.getColumnDescriptors()));
        ci.addInput(InputFactory.createPreferredSortOrder());
        ci.addInput(InputFactory.createNormalized());
        ci.addInput(InputFactory.createBackdrop());
        ci.addInput((IInput)InputFactory.createName());
        ci.addInput(InputFactory.createDescription());
        ci.addInput(InputFactory.createColumnWeightFactor());
        ci.addInput(InputFactory.createMinimumWidth());
        ci.addInput(InputFactory.createUnit(false));
        return ci;
    }

    private IInput createDataProvider() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (EventTableDescriptor etd : EventTableProviderRepository.getProviderDescriptors()) {
            map.put(etd.getIdentifier(), etd.getName());
        }
        return new ComboInput(DATA_PROVIDER, Messages.INPUT_CUSTOM_TABLE_EVENT, map);
    }
}

