/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;

abstract class LayoutSubPart {
    private final IWorkbenchSite m_site;
    private Control m_control;
    private DesignerTab m_designerTab;

    public LayoutSubPart(IWorkbenchSite site) {
        this.m_site = site;
    }

    public final void update() {
        IServiceLocator s = this.getServiceLocator();
        if (s != null && this.m_designerTab != null && this.m_designerTab.isInDesignMode()) {
            this.enableControl();
            this.updateControl();
            return;
        }
        this.disableControl();
    }

    protected abstract void updateControl();

    protected abstract void enableControl();

    protected abstract void disableControl();

    protected abstract Control createPart(Composite var1);

    protected final IWorkbenchSite getSite() {
        return this.m_site;
    }

    protected final DesignerTab getDesignerTab() {
        return this.m_designerTab;
    }

    protected final IServiceLocator getServiceLocator() {
        if (this.m_designerTab != null) {
            return this.m_designerTab.getServiceLocator();
        }
        return null;
    }

    protected final IDesignElement getDesignElement() {
        if (this.m_designerTab != null) {
            return this.m_designerTab.getSelectedElemented();
        }
        return null;
    }

    public final Control getControl() {
        return this.m_control;
    }

    public final void setFocus() {
        Control control = this.getControl();
        if (control != null) {
            control.setFocus();
        }
    }

    public final Control create(Composite container) {
        this.m_control = this.createPart(container);
        return this.m_control;
    }

    public void dispose() {
        this.m_designerTab = null;
        if (this.m_control != null) {
            this.m_control.dispose();
        }
    }

    public final void setTab(DesignerTab tab) {
        this.m_designerTab = tab;
    }
}

