/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Observable;
import java.util.Observer;
import oracle.jvm.hotspot.jfr.JFRDebug;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class StreamWriter
extends VMObject {
    private static AddressField bufferField;
    private static CIntegerField bufferSizeField;
    private static CIntegerField bufPosField;
    private static Field streamPosField;
    private long streamPos;
    private long bufPos;
    private String path;
    private RandomAccessFile out;

    public StreamWriter(Address addr) {
        super(addr);
        this.bufPos = bufPosField.getValue(addr);
        this.streamPos = 0L;
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("streamwriter");
        bufferField = type.getAddressField("_buffer");
        bufferSizeField = type.getCIntegerField("_buffer_size");
        bufPosField = type.getCIntegerField("_buf_pos");
        streamPosField = type.getField("_stream_pos");
    }

    public void setFilePath(String pathName) {
        this.path = pathName;
        try {
            File f = new File(this.path);
            if (f.exists()) {
                f.delete();
            }
            this.out = new RandomAccessFile(this.path, "rwd");
            if (JFRDebug.SA_JFR_DEBUG) {
                System.out.println("StreamWriter.setFilePath(): Opened recording file = " + this.out);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public long getBufferSize() {
        return bufferSizeField.getValue(this.addr);
    }

    public long getBufferPos() {
        return this.bufPos;
    }

    public long getStreamPos() {
        return this.streamPos;
    }

    public long getCurrentPos() {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("StreamWriter.getCurrentPos(): _stream_pos = " + this.streamPos + " _buf_pos = " + this.bufPos);
        }
        return this.streamPos + this.bufPos;
    }

    public void setStreamPos(long pos) {
        this.streamPos = pos;
    }

    public byte[] getBuffer() {
        int size = (int)this.getBufferPos();
        Address buf = bufferField.getValue(this.addr);
        byte[] buffer = new byte[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = buf.getJByteAt(i);
        }
        return buffer;
    }

    public void flush_buffer() {
        byte[] buffer = this.getBuffer();
        this.write(buffer);
        this.bufPos = 0L;
    }

    public void write(byte[] bytes) {
        try {
            this.out.write(bytes, 0, bytes.length);
            this.streamPos += (long)bytes.length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(boolean b) {
        try {
            this.out.writeBoolean(b);
            ++this.streamPos;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(byte b) {
        try {
            this.out.writeByte(b);
            ++this.streamPos;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(char c) {
        try {
            this.out.writeChar(c);
            this.streamPos += 2L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(short b) {
        try {
            this.out.writeShort(b);
            this.streamPos += 2L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(int b) {
        try {
            this.out.writeInt(b);
            this.streamPos += 4L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write(long b) {
        try {
            this.out.writeLong(b);
            this.streamPos += 8L;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeString(String str) {
        try {
            short len = (short)str.length();
            this.out.writeShort(len);
            this.out.write(str.getBytes());
            this.streamPos += (long)(len + 2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void seek(long pos) {
        if (JFRDebug.SA_JFR_DEBUG) {
            System.out.println("StreamWriter.seek(): Seek to pos = " + pos);
        }
        try {
            this.out.seek(pos);
            this.streamPos = pos;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                StreamWriter.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

