/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.layout;

import com.jrockit.mc.ui.layout.SimpleLayoutData;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SimpleLayout
extends Layout {
    public static final int INFINITE_SIZE = Integer.MAX_VALUE;
    public static final float INFINITE_RATIO = Float.MAX_VALUE;
    public static final float INIFINITE_WEIGHT = Float.MAX_VALUE;
    public static final int ZERO_SIZE = 0;
    public static final double ZERO_WEIGHT = 0.0;
    public static final int PREFERRED_SIZE = Integer.MIN_VALUE;
    private int m_spacing = 6;
    private int m_margin = 6;
    private int m_style = 4;
    private boolean m_horizontalOrientation = true;

    public static SimpleLayout createMarginFree() {
        SimpleLayout layout = new SimpleLayout();
        layout.setMargin(0);
        layout.setSpacing(0);
        return layout;
    }

    public void setHorizontalOrientation(boolean horizontal) {
        this.m_horizontalOrientation = horizontal;
    }

    public void setAlignment(int style) {
        this.m_style = style;
    }

    public boolean getHorizontalOrientation() {
        return this.m_horizontalOrientation;
    }

    public void setMargin(int pixels) {
        this.m_margin = pixels;
    }

    public int getMargin() {
        return this.m_margin;
    }

    public void setSpacing(int spacing) {
        this.m_spacing = spacing;
    }

    public int getSpacing() {
        return this.m_spacing;
    }

    protected CalculationData[] createCalculationData(Control[] controls, int size, int otherSize) {
        CalculationData[] cd = this.createCalculationDataArray(controls.length);
        SimpleLayoutData[] md = this.createLayoutDataArray(controls);
        this.fillPreferredSize(controls, cd, otherSize);
        this.fillMinAndMaxSize(md, cd);
        this.fillWeight(md, cd, size);
        if (this.getHorizontalOrientation()) {
            this.fillHorizontalRatio(md, cd, size, otherSize);
        }
        return cd;
    }

    protected CalculationData[] createCalculationDataArray(int size) {
        CalculationData[] cd = new CalculationData[size];
        int n = 0;
        while (n < size) {
            cd[n] = new CalculationData();
            ++n;
        }
        return cd;
    }

    protected void fillPreferredSize(Control[] controls, CalculationData[] cd, int otherSize) {
        int n = 0;
        while (n < cd.length) {
            cd[n].preferredSize = this.getHorizontalOrientation() ? controls[n].computeSize((int)-1, (int)otherSize).x : controls[n].computeSize((int)otherSize, (int)-1).y;
            ++n;
        }
    }

    protected void fillHorizontalRatio(SimpleLayoutData[] layoutData, CalculationData[] calculationData, int horizontal, int verticalSize) {
        if (this.getHorizontalOrientation()) {
            int n = 0;
            while (n < layoutData.length) {
                SimpleLayoutData ld = layoutData[n];
                CalculationData cd = calculationData[n];
                if (ld.getMinimumHorizontalRatio() > 0.0f) {
                    cd.minSize = Math.max(cd.minSize, (int)((double)(ld.getMinimumHorizontalRatio() * (float)verticalSize) + 0.5));
                }
                if (ld.getMaximumHorizontalRatio() < Float.MAX_VALUE) {
                    cd.maxSize = Math.min(cd.maxSize, (int)((double)(ld.getMaximumHorizontalRatio() * (float)verticalSize) + 0.5));
                }
                cd.minSize = Math.min(cd.minSize, cd.maxSize);
                cd.maxSize = Math.max(cd.minSize, cd.maxSize);
                ++n;
            }
        }
    }

    protected void fillWeight(SimpleLayoutData[] layoutData, CalculationData[] calculationData, int size) {
        int n = 0;
        while (n < calculationData.length) {
            CalculationData cd = calculationData[n];
            cd.weight = layoutData[n].getWeight();
            cd.weightPriorityValue = cd.weight;
            this.ensurePositive(cd.weight, "Weight");
            if ((double)cd.weight == 0.0) {
                cd.maxSize = cd.minSize;
            }
            ++n;
        }
    }

    private void ensurePositive(double value, String valueName) {
        if (value < 0.0) {
            throw new IllegalArgumentException(String.valueOf(valueName) + " value must be a positive value.");
        }
    }

    protected void fillMinAndMaxSize(SimpleLayoutData[] layoutData, CalculationData[] calculationData) {
        int n = 0;
        while (n < layoutData.length) {
            CalculationData cd = calculationData[n];
            cd.minSize = layoutData[n].getMinimumSize();
            cd.maxSize = layoutData[n].getMaximumSize();
            if (cd.minSize == Integer.MIN_VALUE) {
                cd.minSize = cd.preferredSize;
            }
            if (cd.maxSize == Integer.MIN_VALUE) {
                cd.maxSize = cd.preferredSize;
            }
            this.ensurePositive(cd.minSize, "Minimum size");
            this.ensurePositive(cd.maxSize, "Maximum size");
            if (cd.maxSize < cd.minSize) {
                cd.minSize = cd.maxSize;
            }
            ++n;
        }
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (composite.getChildren().length != 0) {
            if (!this.getHorizontalOrientation()) {
                return new Point(this.computeMinimumWidth(composite, wHint, flushCache), this.calculateMinimumSize(composite));
            }
            return new Point(this.calculateMinimumSize(composite), this.computeMinimumHeight(composite, hHint, flushCache));
        }
        return new Point(wHint == -1 ? 2 * this.m_margin : wHint, hHint == -1 ? 2 * this.m_margin : hHint);
    }

    private int computeMinimumWidth(Composite composite, int wHint, boolean flushCache) {
        int maxWidth = 0;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point size = child.computeSize(wHint, -1, flushCache);
            maxWidth = Math.max(maxWidth, size.x);
            ++n2;
        }
        return maxWidth + 2 * this.m_margin;
    }

    private int computeMinimumHeight(Composite composite, int hHint, boolean flushCache) {
        int maxHeight = 0;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Point size = child.computeSize(-1, hHint, flushCache);
            maxHeight = Math.max(maxHeight, size.y);
            ++n2;
        }
        return maxHeight + 2 * this.m_margin;
    }

    protected int calculateMinimumSize(Composite composite) {
        Control[] children;
        int totalSize = 2 * this.m_margin;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            SimpleLayoutData sd = this.getSimpleLayoutData(element);
            int size = Math.min(sd.getMinimumSize(), sd.getMaximumSize());
            if (size > 0) {
                totalSize += size + this.m_spacing;
            }
            ++n2;
        }
        return totalSize;
    }

    private SimpleLayoutData getSimpleLayoutData(Control control) throws IllegalStateException {
        Object ld = control.getLayoutData();
        if (!(ld instanceof SimpleLayoutData)) {
            throw new IllegalStateException("SimpleLayout requires that all children have SimpeLayoutData set");
        }
        return (SimpleLayoutData)ld;
    }

    protected SimpleLayoutData[] createLayoutDataArray(Control[] controls) {
        SimpleLayoutData[] md = new SimpleLayoutData[controls.length];
        int n = 0;
        while (n < controls.length) {
            md[n] = this.getSimpleLayoutData(controls[n]);
            ++n;
        }
        return md;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Control[] controls = this.getVisibleChildren(composite);
        if (controls.length > 0) {
            Rectangle clientArea = composite.getClientArea();
            int fixedOrientation = this.getHorizontalOrientation() ? clientArea.height : clientArea.width;
            int dynamicOrientation = this.getHorizontalOrientation() ? clientArea.width : clientArea.height;
            int totalMargin = 2 * this.m_margin;
            int totalSpacing = (controls.length - 1) * this.m_spacing;
            if ((dynamicOrientation -= totalMargin + totalSpacing) > 0 && (fixedOrientation -= totalMargin) > 0) {
                this.layoutControls(controls, dynamicOrientation, fixedOrientation);
            }
        }
    }

    private void layoutControls(Control[] controls, int dynamic, int fixed) {
        CalculationData[] data = this.createCalculationData(controls, dynamic, fixed);
        int leftOver = this.distributeMinSize(data, dynamic);
        leftOver = SimpleLayout.distributeWeights(data, leftOver);
        switch (this.getAlignment()) {
            case 1: {
                this.layoutOut(controls, data, fixed, 0);
                break;
            }
            case 4: {
                this.distributeFillPad(data, leftOver);
                this.layoutOut(controls, data, fixed, 0);
                break;
            }
            case 0x1000008: {
                this.layoutOut(controls, data, fixed, leftOver);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid alignment encountered. Only SWT.FIll, SWT.BEGINNING and SWT.END are allowed");
            }
        }
    }

    private int distributeMinSize(CalculationData[] data, int size) {
        int n = 0;
        while (n < data.length) {
            if (data[n].minSize > data[n].size) {
                size -= data[n].minSize - data[n].size;
                data[n].size = data[n].minSize;
            }
            ++n;
        }
        return size;
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    private Control[] getVisibleChildren(Composite composite) {
        Control[] children = composite.getChildren();
        ArrayList<Control> list = new ArrayList<Control>();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            SimpleLayoutData md = this.getSimpleLayoutData(element);
            if (md.isVisible()) {
                list.add(element);
            }
            ++n2;
        }
        return list.toArray(new Control[list.size()]);
    }

    private void distributeFillPad(CalculationData[] data, int size) {
        if (size > 0) {
            int count = data.length * 2;
            float averageSpill = (float)size / (float)count;
            float spillDistributed = 0.0f;
            int n = 0;
            while (n < count) {
                int spill = (int)((float)(n + 1) * averageSpill - spillDistributed);
                if (n % 2 == 0) {
                    data[n / 2].prePad += spill;
                } else {
                    data[n / 2].postPad += spill;
                }
                spillDistributed += (float)spill;
                ++n;
            }
        }
    }

    public int getAlignment() {
        return this.m_style;
    }

    protected void layoutOut(Control[] controls, CalculationData[] data, int fixedOrientationSize, int pixelPosition) {
        int n = 0;
        while (n < data.length) {
            pixelPosition += data[n].prePad;
            if (this.getHorizontalOrientation()) {
                controls[n].setBounds(this.m_margin + pixelPosition, this.m_margin, data[n].size, fixedOrientationSize);
            } else {
                controls[n].setBounds(this.m_margin, this.m_margin + pixelPosition, fixedOrientationSize, data[n].size);
            }
            pixelPosition += data[n].size + data[n].postPad + this.m_spacing;
            ++n;
        }
    }

    protected static int distributeWeights(CalculationData[] unSortedData, int size) {
        if (size > 0) {
            int topElement = 0;
            Object[] heap = (CalculationData[])unSortedData.clone();
            Arrays.sort(heap);
            do {
                if (((CalculationData)heap[topElement]).size < ((CalculationData)heap[topElement]).maxSize) {
                    ++((CalculationData)heap[topElement]).size;
                    ((CalculationData)heap[topElement]).weightPriorityValue += (double)((CalculationData)heap[topElement]).weight;
                    SimpleLayout.bubbleTopElementDown(topElement, (CalculationData[])heap);
                    --size;
                    continue;
                }
                ++topElement;
            } while (size > 0 && topElement < heap.length);
        }
        return size;
    }

    private static void bubbleTopElementDown(int topElement, CalculationData[] heap) {
        int n = topElement;
        while (n < heap.length - 1 && heap[n].weightPriorityValue > heap[n + 1].weightPriorityValue) {
            CalculationData tmp = heap[n];
            heap[n] = heap[n + 1];
            heap[n + 1] = tmp;
            ++n;
        }
    }

    private static class CalculationData
    implements Comparable<CalculationData> {
        public int size;
        public float weight;
        public int maxSize;
        public int minSize;
        public int preferredSize;
        public int prePad;
        public int postPad;
        public double weightPriorityValue;

        private CalculationData() {
        }

        @Override
        public int compareTo(CalculationData arg0) {
            double diff = this.weightPriorityValue - arg0.weightPriorityValue;
            if (diff == 0.0) {
                return 0;
            }
            return diff > 0.0 ? 1 : -1;
        }
    }
}

