/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.UnknownHostException;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbApReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KDCReqBody;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.TGSReq;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.crypto.Nonce;

public class KrbTgsReq {
    private PrincipalName princName;
    private PrincipalName servName;
    private TGSReq tgsReqMessg;
    private KerberosTime ctime;
    private Ticket secondTicket = null;
    private boolean useSubkey = false;
    EncryptionKey tgsReqKey;
    private static final boolean DEBUG = Krb5.DEBUG;
    private byte[] obuf;
    private byte[] ibuf;

    public KrbTgsReq(Credentials credentials, PrincipalName principalName) throws KrbException, IOException {
        this(new KDCOptions(), credentials, principalName, null, null, null, null, null, null, null, null);
    }

    public KrbTgsReq(Credentials credentials, Ticket ticket, PrincipalName principalName) throws KrbException, IOException {
        this(KDCOptions.with(14, 1), credentials, principalName, null, null, null, null, null, null, new Ticket[]{ticket}, null);
    }

    public KrbTgsReq(Credentials credentials, PrincipalName principalName, PAData pAData) throws KrbException, IOException {
        this(KDCOptions.with(1), credentials, credentials.getClient(), principalName, null, null, null, null, null, null, null, null, pAData);
    }

    KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket[] ticketArray, EncryptionKey encryptionKey) throws KrbException, IOException {
        this(kDCOptions, credentials, credentials.getClient(), principalName, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, authorizationData, ticketArray, encryptionKey, null);
    }

    private KrbTgsReq(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket[] ticketArray, EncryptionKey encryptionKey, PAData pAData) throws KrbException, IOException {
        this.princName = principalName;
        this.servName = principalName2;
        this.ctime = KerberosTime.now();
        if (kDCOptions.get(1) && !credentials.flags.get(1)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(2) && !credentials.flags.get(1)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(3) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(4) && !credentials.flags.get(3)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(5) && !credentials.flags.get(5)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(8) && !credentials.flags.get(8)) {
            throw new KrbException(101);
        }
        if (kDCOptions.get(6)) {
            if (!credentials.flags.get(6)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime != null) {
            kerberosTime = null;
        }
        if (kDCOptions.get(8)) {
            if (!credentials.flags.get(8)) {
                throw new KrbException(101);
            }
        } else if (kerberosTime3 != null) {
            kerberosTime3 = null;
        }
        if (kDCOptions.get(28) || kDCOptions.get(14)) {
            if (ticketArray == null) {
                throw new KrbException(101);
            }
            this.secondTicket = ticketArray[0];
        } else if (ticketArray != null) {
            ticketArray = null;
        }
        this.tgsReqMessg = this.createRequest(kDCOptions, credentials.ticket, credentials.key, this.ctime, this.princName, this.servName, kerberosTime, kerberosTime2, kerberosTime3, nArray, hostAddresses, authorizationData, ticketArray, encryptionKey, pAData);
        this.obuf = this.tgsReqMessg.asn1Encode();
        if (credentials.flags.get(2)) {
            kDCOptions.set(2, true);
        }
    }

    public void send() throws IOException, KrbException {
        String string = null;
        if (this.servName != null) {
            string = this.servName.getRealmString();
        }
        KdcComm kdcComm = new KdcComm(string);
        this.ibuf = kdcComm.send(this.obuf);
    }

    public KrbTgsRep getReply() throws KrbException, IOException {
        return new KrbTgsRep(this.ibuf, this);
    }

    public Credentials sendAndGetCreds() throws IOException, KrbException {
        KrbTgsRep krbTgsRep = null;
        Object var2_2 = null;
        this.send();
        krbTgsRep = this.getReply();
        return krbTgsRep.getCreds();
    }

    KerberosTime getCtime() {
        return this.ctime;
    }

    private TGSReq createRequest(KDCOptions kDCOptions, Ticket ticket, EncryptionKey encryptionKey, KerberosTime kerberosTime, PrincipalName principalName, PrincipalName principalName2, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, int[] nArray, HostAddresses hostAddresses, AuthorizationData authorizationData, Ticket[] ticketArray, EncryptionKey encryptionKey2, PAData pAData) throws IOException, KrbException, UnknownHostException {
        PAData[] pADataArray;
        Checksum checksum;
        Object object;
        KerberosTime kerberosTime5 = null;
        kerberosTime5 = kerberosTime3 == null ? new KerberosTime(0L) : kerberosTime3;
        this.tgsReqKey = encryptionKey;
        int[] nArray2 = null;
        nArray2 = nArray == null ? EType.getDefaults("default_tgs_enctypes") : nArray;
        EncryptionKey encryptionKey3 = null;
        EncryptedData encryptedData = null;
        if (authorizationData != null) {
            object = authorizationData.asn1Encode();
            if (encryptionKey2 != null) {
                encryptionKey3 = encryptionKey2;
                this.tgsReqKey = encryptionKey2;
                this.useSubkey = true;
                encryptedData = new EncryptedData(encryptionKey3, (byte[])object, 5);
            } else {
                encryptedData = new EncryptedData(encryptionKey, (byte[])object, 4);
            }
        }
        object = new KDCReqBody(kDCOptions, principalName, principalName2, kerberosTime2, kerberosTime5, kerberosTime4, Nonce.value(), nArray2, hostAddresses, encryptedData, ticketArray);
        byte[] byArray = ((KDCReqBody)object).asn1Encode(12);
        switch (Checksum.CKSUMTYPE_DEFAULT) {
            case -138: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: {
                checksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, byArray, encryptionKey, 6);
                break;
            }
            default: {
                checksum = new Checksum(Checksum.CKSUMTYPE_DEFAULT, byArray);
            }
        }
        byte[] byArray2 = new KrbApReq(new APOptions(), ticket, encryptionKey, principalName, checksum, kerberosTime, encryptionKey3, null, null).getMessage();
        PAData pAData2 = new PAData(1, byArray2);
        if (pAData != null) {
            PAData[] pADataArray2 = new PAData[2];
            pADataArray2[0] = pAData;
            pADataArray = pADataArray2;
            pADataArray2[1] = pAData2;
        } else {
            PAData[] pADataArray3 = new PAData[1];
            pADataArray = pADataArray3;
            pADataArray3[0] = pAData2;
        }
        return new TGSReq(pADataArray, (KDCReqBody)object);
    }

    TGSReq getMessage() {
        return this.tgsReqMessg;
    }

    Ticket getSecondTicket() {
        return this.secondTicket;
    }

    private static void debug(String string) {
    }

    boolean usedSubkey() {
        return this.useSubkey;
    }
}

