/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.util.concurrent.ConcurrentHashMap;
import jdk.management.resource.ResourceContext;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.SimpleResourceContext;
import jdk.management.resource.internal.WeakKeyConcurrentHashMap;

public final class ApproverGroup {
    private static final ConcurrentHashMap<ResourceType, ApproverGroup> approverGroups = new ConcurrentHashMap();
    private final WeakKeyConcurrentHashMap<Object, ResourceContext> approvers;
    private final ResourceType type;
    private final boolean isBoundToContext;
    private static final ResourceRequest fallback = (l, resourceId) -> l;
    public static final ApproverGroup FILE_OPEN_GROUP = ApproverGroup.create(ResourceType.FILE_OPEN, true);
    public static final ApproverGroup FILE_READ_GROUP = ApproverGroup.create(ResourceType.FILE_READ, false);
    public static final ApproverGroup FILE_WRITE_GROUP = ApproverGroup.create(ResourceType.FILE_WRITE, false);
    public static final ApproverGroup STDERR_WRITE_GROUP = ApproverGroup.create(ResourceType.STDERR_WRITE, false);
    public static final ApproverGroup STDIN_READ_GROUP = ApproverGroup.create(ResourceType.STDIN_READ, false);
    public static final ApproverGroup STDOUT_WRITE_GROUP = ApproverGroup.create(ResourceType.STDOUT_WRITE, false);
    public static final ApproverGroup SOCKET_OPEN_GROUP = ApproverGroup.create(ResourceType.SOCKET_OPEN, true);
    public static final ApproverGroup SOCKET_READ_GROUP = ApproverGroup.create(ResourceType.SOCKET_READ, false);
    public static final ApproverGroup SOCKET_WRITE_GROUP = ApproverGroup.create(ResourceType.SOCKET_WRITE, false);
    public static final ApproverGroup DATAGRAM_OPEN_GROUP = ApproverGroup.create(ResourceType.DATAGRAM_OPEN, true);
    public static final ApproverGroup DATAGRAM_RECEIVED_GROUP = ApproverGroup.create(ResourceType.DATAGRAM_RECEIVED, false);
    public static final ApproverGroup DATAGRAM_SENT_GROUP = ApproverGroup.create(ResourceType.DATAGRAM_SENT, false);
    public static final ApproverGroup DATAGRAM_READ_GROUP = ApproverGroup.create(ResourceType.DATAGRAM_READ, false);
    public static final ApproverGroup DATAGRAM_WRITE_GROUP = ApproverGroup.create(ResourceType.DATAGRAM_WRITE, false);
    public static final ApproverGroup THREAD_CREATED_GROUP = ApproverGroup.create(ResourceType.THREAD_CREATED, true);
    public static final ApproverGroup THREAD_CPU_GROUP = ApproverGroup.create(ResourceType.THREAD_CPU, false);
    public static final ApproverGroup FILEDESCRIPTOR_OPEN_GROUP = ApproverGroup.create(ResourceType.FILEDESCRIPTOR_OPEN, true);

    public static ApproverGroup getGroup(ResourceType resourceType) {
        return approverGroups.get(resourceType);
    }

    public static ApproverGroup create(ResourceType resourceType2, boolean bl) {
        return approverGroups.computeIfAbsent(resourceType2, resourceType -> new ApproverGroup((ResourceType)resourceType, bl));
    }

    private ApproverGroup(ResourceType resourceType, boolean bl) {
        this.type = resourceType;
        this.isBoundToContext = bl;
        this.approvers = new WeakKeyConcurrentHashMap();
    }

    public final ResourceType getId() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ResourceRequest getApprover(Object object2) {
        ResourceContext resourceContext;
        if (this.isBoundToContext) {
            if (object2 == null) throw new ResourceRequestDeniedException("null resource instance for ResourceType: " + this.type);
            resourceContext = this.approvers.computeIfAbsent(object2, object -> SimpleResourceContext.getThreadContext(Thread.currentThread()));
        } else {
            resourceContext = SimpleResourceContext.getThreadContext(Thread.currentThread());
        }
        ResourceRequest resourceRequest = resourceContext.getResourceRequest(this.type);
        return resourceRequest != null ? resourceRequest : fallback;
    }

    public void purgeResourceContext(ResourceContext resourceContext) {
        this.approvers.purgeValue(resourceContext);
    }
}

