/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.Mnemonics;

final class ButtonsHTMLParser {
    static final Logger logger = Logger.getLogger(ButtonsHTMLParser.class.getName());
    private final InputStream is;
    private FormHTMLParser formParser;
    private List<Object> options;
    private List<Object> additionalOptions;
    private boolean containsExitButton;

    public ButtonsHTMLParser(InputStream inputStream) {
        this.is = inputStream;
    }

    void parse() throws IOException {
        ParserDelegator parserDelegator = new ParserDelegator();
        InputStreamReader inputStreamReader = new InputStreamReader(this.is, "utf-8");
        this.formParser = new FormHTMLParser();
        parserDelegator.parse(inputStreamReader, this.formParser, true);
    }

    void createButtons() {
        if (this.formParser == null) {
            throw new IllegalStateException("parse() must be called before this.");
        }
        this.options = new ArrayList<Object>();
        this.additionalOptions = new ArrayList<Object>();
        List<MutableAttributeSet> list = this.formParser.getInputs();
        if (list.isEmpty()) {
            return;
        }
        String string = ButtonsHTMLParser.attrValue((AttributeSet)list.get(0), HTML.Attribute.ACTION);
        if (string == null || string.isEmpty()) {
            throw new IllegalStateException("Action should not be empty");
        }
        String string2 = string;
        for (int i = 1; i < list.size(); ++i) {
            Object object;
            List<Object> list2;
            MutableAttributeSet mutableAttributeSet = list.get(i);
            String string3 = ButtonsHTMLParser.attrValue((AttributeSet)mutableAttributeSet, HTML.Attribute.NAME);
            String string4 = ButtonsHTMLParser.attrValue((AttributeSet)mutableAttributeSet, HTML.Attribute.VALUE);
            String string5 = ButtonsHTMLParser.attrValue((AttributeSet)mutableAttributeSet, HTML.Attribute.ALIGN);
            String string6 = ButtonsHTMLParser.attrValue((AttributeSet)mutableAttributeSet, HTML.Attribute.ALT);
            boolean bl = true;
            String string7 = ButtonsHTMLParser.attrValue((AttributeSet)mutableAttributeSet, "disabled");
            if ("true".equals(string7)) {
                bl = false;
            } else if ("disabled".equals(string7)) {
                bl = false;
            }
            List<Object> list3 = list2 = "left".equals(string5) ? this.additionalOptions : this.options;
            if (Installer.Button.isSubmitTrigger(string3)) {
                object = string4;
                JButton jButton = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)jButton, (String)object);
                jButton.setActionCommand(string3);
                jButton.putClientProperty("url", string2);
                jButton.setDefaultCapable(list2.isEmpty() && list2 == this.options);
                jButton.putClientProperty("alt", string6);
                jButton.putClientProperty("now", object);
                jButton.setEnabled(bl);
                list2.add(jButton);
                continue;
            }
            object = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)object, (String)string4);
            ((AbstractButton)object).setActionCommand(string3);
            ((JButton)object).setDefaultCapable(list2.isEmpty() && list2 == this.options);
            ((JComponent)object).putClientProperty("alt", string6);
            ((JComponent)object).putClientProperty("now", string4);
            ((AbstractButton)object).setEnabled(bl && Installer.Button.isKnown(string3));
            list2.add(object);
            if (Installer.Button.EXIT.isCommand(string3)) {
                this.containsExitButton = true;
            }
            if (!Installer.Button.REDIRECT.isCommand(string3)) continue;
            ((JComponent)object).putClientProperty("url", string2);
        }
    }

    private static String attrValue(AttributeSet attributeSet, Object object) {
        Object object2 = attributeSet.getAttribute(object);
        if (object2 == null) {
            return null;
        }
        if (!(object2 instanceof String)) {
            throw new IllegalStateException("Attribute " + object + " has a wrong value: " + object2);
        }
        return (String)object2;
    }

    private static String attrValue(AttributeSet attributeSet, String string) {
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!string.equalsIgnoreCase(obj.toString())) continue;
            return ButtonsHTMLParser.attrValue(attributeSet, obj);
        }
        return null;
    }

    List<Object> getOptions() {
        return this.options;
    }

    List<Object> getAdditionalOptions() {
        return this.additionalOptions;
    }

    String getTitle() {
        return this.formParser.getTitle();
    }

    boolean containsExitButton() {
        return this.containsExitButton;
    }

    private static final class FormHTMLParser
    extends HTMLEditorKit.ParserCallback {
        private static final String TAG_TITLE = "title";
        private static final String TAG_FORM = "form";
        private static final String TAG_INPUT = "input";
        private boolean readingTitle = false;
        private String title;
        private boolean readingForm = false;
        private final List<MutableAttributeSet> inputs = new ArrayList<MutableAttributeSet>();

        private FormHTMLParser() {
        }

        public String getTitle() {
            return this.title;
        }

        public List<MutableAttributeSet> getInputs() {
            return this.inputs;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            String string = tag.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "StartTag <{0}> with attributes: {1}", new Object[]{string, Collections.list(mutableAttributeSet.getAttributeNames()).toString()});
            }
            if (TAG_TITLE.equalsIgnoreCase(string)) {
                this.readingTitle = true;
                return;
            }
            this.readingTitle = false;
            if (TAG_FORM.equalsIgnoreCase(string)) {
                this.readingForm = true;
                this.inputs.clear();
                this.inputs.add(new SimpleAttributeSet(mutableAttributeSet));
                return;
            }
            if (this.readingForm && TAG_INPUT.equalsIgnoreCase(string)) {
                this.inputs.add(new SimpleAttributeSet(mutableAttributeSet));
            }
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int n) {
            String string = tag.toString();
            logger.log(Level.FINE, "EndTag <{0}>", string);
            if (TAG_TITLE.equalsIgnoreCase(string)) {
                this.readingTitle = false;
            }
            if (TAG_FORM.equalsIgnoreCase(string)) {
                this.readingForm = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
            String string = tag.toString();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SimpleTag <{0}> with attributes: {1}", new Object[]{string, Collections.list(mutableAttributeSet.getAttributeNames()).toString()});
            }
            if (this.readingForm && TAG_INPUT.equalsIgnoreCase(string)) {
                this.inputs.add(new SimpleAttributeSet(mutableAttributeSet));
            }
        }

        @Override
        public void handleText(char[] cArray, int n) {
            if (logger.isLoggable(Level.FINE)) {
                String string = new String(cArray);
                logger.log(Level.FINE, "Text: ''{0}''", new Object[]{string});
            }
            if (this.readingTitle) {
                this.title = new String(cArray);
            }
        }

        @Override
        public void handleError(String string, int n) {
            logger.log(Level.FINE, "Error: ''{0}'' at {1}", new Object[]{string, n});
        }
    }
}

