/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.ui.column.ColumnsToolkit;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.TableColumnComposite;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.IAttributeSet;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.RemoveAttributeAction;
import com.jrockit.mc.rjmx.ui.internal.StatisticsCalculator;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.misc.MCArrayContentProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.SelectionProviderAction;

public class StatisticsTable {
    private StatisticsTable() {
        throw new UnsupportedOperationException("StatisticsTable should not be instantiated");
    }

    public static TableColumnComposite create(Composite parent, AttributeLabelProvider attributeLp, IAttributeSet attributes, boolean addResetAction) {
        IColumn name = ColumnsToolkit.createColumn(Messages.StatisticsTable_ATTRIBUTE_NAME, Messages.StatisticsTable_ATTRIBUTE_DESCRIPTION, "attribute", attributeLp, StatisticsCalculator.GET_ATTRIBUTE);
        IColumn last = ColumnsToolkit.createComparedColumn(Messages.StatisticsTable_VALUE_NAME, Messages.StatisticsTable_VALUE_DESCRIPTION, "value", StatisticsCalculator.GET_LAST);
        IColumn min = ColumnsToolkit.createComparedColumn(Messages.StatisticsTable_MINIMUM_NAME, Messages.StatisticsTable_MINIMUM_DESCRIPTION, "min", StatisticsCalculator.GET_MIN);
        IColumn max = ColumnsToolkit.createComparedColumn(Messages.StatisticsTable_MAXIMUM_NAME, Messages.StatisticsTable_MAXIMUM_DESCRIPTION, "max", StatisticsCalculator.GET_MAX);
        IColumn av = ColumnsToolkit.createComparedColumn(Messages.StatisticsTable_AVERAGE_NAME, Messages.StatisticsTable_AVERAGE_DESCRIPTION, "average", StatisticsCalculator.GET_AVERAGE);
        IColumn sigma = ColumnsToolkit.createComparedColumn("\u03c3", Messages.StatisticsTable_SIGMA_DESCRIPTION, "sigma", StatisticsCalculator.GET_SIGMA);
        DialogSettings settings = new DialogSettings("");
        settings.put("sort_column", "attribute");
        final TableColumnComposite table = new TableColumnComposite(parent, 0, (IDialogSettings)settings);
        table.addColumns(name, last, min, max, av, sigma);
        table.getViewer().setContentProvider((IContentProvider)MCArrayContentProvider.INSTANCE);
        table.getMenuManager().add((IContributionItem)new Separator());
        if (addResetAction) {
            table.getMenuManager().add((IAction)new SelectionProviderAction((ISelectionProvider)table.getViewer(), Messages.AttributeDialSectionPart_CLEAR_STATISTICS_MENU_TEXT){

                public void run() {
                    for (Object o : this.getStructuredSelection().toList()) {
                        ((StatisticsCalculator)o).reset();
                    }
                    table.getViewer().refresh();
                }

                public void selectionChanged(IStructuredSelection selection) {
                    this.setEnabled(!selection.isEmpty());
                }
            });
        }
        RemoveAttributeAction removeAction = new RemoveAttributeAction((ISelectionProvider)table.getViewer(), attributes);
        table.getMenuManager().add((IAction)removeAction);
        InFocusHandlerActivator.install((Control)table.getViewer().getControl(), (IAction)removeAction);
        return table;
    }
}

