/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.alert.AlertObject;
import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.alert.NotificationUIToolkit;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderToolkit;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;

public class WriteAndOpenRecordingJob
extends Job {
    private final String serverName;
    private final IFlightRecorderService service;
    private final MCFile path;
    private final Long timerange;
    private final boolean open;
    private TriggerEvent event;

    public WriteAndOpenRecordingJob(String jobName, String serverName, IFlightRecorderService service, MCFile path, Long timerange, boolean open, TriggerEvent event) {
        super(jobName);
        this.service = service;
        this.serverName = serverName;
        this.path = path;
        this.timerange = timerange;
        this.open = open;
        this.event = event;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String recordingName;
        try {
            IRecordingDescriptor descriptor = this.findRecording();
            if (descriptor == null) {
                RJMXPlugin.getDefault().getLogger().severe("There is no usable recording running at " + this.serverName);
                return new Status(4, "com.jrockit.mc.console.ui.notification", Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_COULD_NOT_FIND_RECORDING);
            }
            recordingName = descriptor.getName();
            File writtenFile = this.writeFile(monitor, descriptor, this.timerange);
            if (this.open) {
                WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile));
            } else {
                this.showAlert(writtenFile, this.event);
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not dump recording. Faulty rule in console?", e);
            return new Status(4, "com.jrockit.mc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_ERROR_MESSAGE_DUMPING_RECORDING, (Object)this.serverName), (Throwable)e);
        }
        return new Status(0, "com.jrockit.mc.console.ui.notification", NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)recordingName));
    }

    private void showAlert(File file, TriggerEvent event) {
        AlertObject ao = new AlertObject(event.getCreationTime(), event.getSource(), event.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_DUMP_SUCCESSFUL_PATH, (Object)file.getAbsolutePath())), null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    private IRecordingDescriptor findRecording() throws FlightRecorderException {
        return FlightRecorderToolkit.getDescriptorByTimerange((List)this.service.getAvailableRecordings(), (Long)this.timerange);
    }

    private File writeFile(IProgressMonitor monitor, IRecordingDescriptor descriptor, Long time) throws FlightRecorderException, IOException {
        InputStream stream = this.service.openStream(descriptor, time.longValue(), false);
        try {
            File file = IDESupportToolkit.writeToUniqueFile((MCFile)this.path, (InputStream)stream, (IProgressMonitor)monitor);
            return file;
        }
        finally {
            IOToolkit.closeSilently((Closeable)stream);
        }
    }
}

