/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;

class GlyphPainter2
extends GlyphView.GlyphPainter {
    TextLayout layout;

    public GlyphPainter2(TextLayout textLayout) {
        this.layout = textLayout;
    }

    @Override
    public GlyphView.GlyphPainter getPainter(GlyphView glyphView, int n, int n2) {
        return null;
    }

    @Override
    public float getSpan(GlyphView glyphView, int n, int n2, TabExpander tabExpander, float f) {
        if (n == glyphView.getStartOffset() && n2 == glyphView.getEndOffset()) {
            return this.layout.getAdvance();
        }
        int n3 = glyphView.getStartOffset();
        int n4 = n - n3;
        int n5 = n2 - n3;
        TextHitInfo textHitInfo = TextHitInfo.afterOffset(n4);
        TextHitInfo textHitInfo2 = TextHitInfo.beforeOffset(n5);
        float[] fArray = this.layout.getCaretInfo(textHitInfo);
        float f2 = fArray[0];
        fArray = this.layout.getCaretInfo(textHitInfo2);
        float f3 = fArray[0];
        return f3 > f2 ? f3 - f2 : f2 - f3;
    }

    @Override
    public float getHeight(GlyphView glyphView) {
        return this.layout.getAscent() + this.layout.getDescent() + this.layout.getLeading();
    }

    @Override
    public float getAscent(GlyphView glyphView) {
        return this.layout.getAscent();
    }

    @Override
    public float getDescent(GlyphView glyphView) {
        return this.layout.getDescent();
    }

    @Override
    public void paint(GlyphView glyphView, Graphics graphics, Shape shape, int n, int n2) {
        if (graphics instanceof Graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            Graphics2D graphics2D = (Graphics2D)graphics;
            float f = (float)rectangle2D.getY() + this.layout.getAscent() + this.layout.getLeading();
            float f2 = (float)rectangle2D.getX();
            if (n > glyphView.getStartOffset() || n2 < glyphView.getEndOffset()) {
                try {
                    Shape shape2 = glyphView.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                    Shape shape3 = graphics.getClip();
                    graphics2D.clip(shape2);
                    this.layout.draw(graphics2D, f2, f);
                    graphics.setClip(shape3);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.layout.draw(graphics2D, f2, f);
            }
        }
    }

    @Override
    public Shape modelToView(GlyphView glyphView, int n, Position.Bias bias, Shape shape) throws BadLocationException {
        int n2 = n - glyphView.getStartOffset();
        Rectangle2D rectangle2D = shape.getBounds2D();
        TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n2) : TextHitInfo.beforeOffset(n2);
        float[] fArray = this.layout.getCaretInfo(textHitInfo);
        rectangle2D.setRect(rectangle2D.getX() + (double)fArray[0], rectangle2D.getY(), 1.0, rectangle2D.getHeight());
        return rectangle2D;
    }

    @Override
    public int viewToModel(GlyphView glyphView, float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle2D rectangle2D = shape instanceof Rectangle2D ? (Rectangle2D)shape : shape.getBounds2D();
        TextHitInfo textHitInfo = this.layout.hitTestChar(f - (float)rectangle2D.getX(), 0.0f);
        int n = textHitInfo.getInsertionIndex();
        if (n == glyphView.getEndOffset()) {
            --n;
        }
        biasArray[0] = textHitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return n + glyphView.getStartOffset();
    }

    @Override
    public int getBoundedPosition(GlyphView glyphView, int n, float f, float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Length must be >= 0.");
        }
        TextHitInfo textHitInfo = this.layout.isLeftToRight() ? this.layout.hitTestChar(f2, 0.0f) : this.layout.hitTestChar(this.layout.getAdvance() - f2, 0.0f);
        return glyphView.getStartOffset() + textHitInfo.getCharIndex();
    }

    @Override
    public int getNextVisualPositionFrom(GlyphView glyphView, int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Document document = glyphView.getDocument();
        int n3 = glyphView.getStartOffset();
        int n4 = glyphView.getEndOffset();
        switch (n2) {
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                boolean bl = AbstractDocument.isLeftToRight(document, n3, n4);
                if (n3 == document.getLength()) {
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    return -1;
                }
                if (n == -1) {
                    if (bl) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    Segment segment = glyphView.getText(n4 - 1, n4);
                    char c = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c == '\n') {
                        biasArray[0] = Position.Bias.Forward;
                        return n4 - 1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                    return n4;
                }
                TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n - n3) : TextHitInfo.beforeOffset(n - n3);
                TextHitInfo textHitInfo2 = this.layout.getNextRightHit(textHitInfo);
                if (textHitInfo2 == null) {
                    return -1;
                }
                if (bl != this.layout.isLeftToRight()) {
                    textHitInfo2 = this.layout.getVisualOtherHit(textHitInfo2);
                }
                if ((n = textHitInfo2.getInsertionIndex() + n3) == n4) {
                    Segment segment = glyphView.getText(n4 - 1, n4);
                    char c = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c == '\n') {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    biasArray[0] = Position.Bias.Forward;
                }
                return n;
            }
            case 7: {
                boolean bl = AbstractDocument.isLeftToRight(document, n3, n4);
                if (n3 == document.getLength()) {
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    return -1;
                }
                if (n == -1) {
                    if (bl) {
                        Segment segment = glyphView.getText(n4 - 1, n4);
                        char c = segment.array[segment.offset];
                        SegmentCache.releaseSharedSegment(segment);
                        if (c == '\n' || Character.isSpaceChar(c)) {
                            biasArray[0] = Position.Bias.Forward;
                            return n4 - 1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                        return n4;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n3;
                }
                TextHitInfo textHitInfo = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(n - n3) : TextHitInfo.beforeOffset(n - n3);
                TextHitInfo textHitInfo3 = this.layout.getNextLeftHit(textHitInfo);
                if (textHitInfo3 == null) {
                    return -1;
                }
                if (bl != this.layout.isLeftToRight()) {
                    textHitInfo3 = this.layout.getVisualOtherHit(textHitInfo3);
                }
                if ((n = textHitInfo3.getInsertionIndex() + n3) == n4) {
                    Segment segment = glyphView.getText(n4 - 1, n4);
                    char c = segment.array[segment.offset];
                    SegmentCache.releaseSharedSegment(segment);
                    if (c == '\n') {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    biasArray[0] = Position.Bias.Forward;
                }
                return n;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }
}

