/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.common.DataSeries;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.FlrSeriesMetaDataProvider;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDataSeries;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.GraphConfig;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.Style;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.chart.FieldFormatter;
import com.jrockit.mc.ui.UIPlugin;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.SeriesMetaDataProvider;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataSeriesProvider;
import se.hirt.greychart.data.RenderingMode;
import se.hirt.greychart.data.SeriesProvider;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.EmptyTitleRenderer;
import se.hirt.greychart.impl.NanosXAxis;
import se.hirt.greychart.impl.TimestampFormatter;

public abstract class ChartModelBuilder<T>
extends ViewModelBuilder<T> {
    private final FLRChartDescriptor m_descriptor;
    private final Set<String> disabled = Collections.synchronizedSet(new HashSet());
    private volatile Point m_size = new Point(1, 1);
    private volatile ITimeRange m_newRange;

    public ChartModelBuilder(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, String name) {
        super(serviceLocator, name);
        for (DataSeriesDescriptor dsd : chartDescriptor.getDataSeriesDescriptors()) {
            dsd.ensureId();
        }
        this.m_descriptor = (FLRChartDescriptor)((Object)PersistenceToolkit.createCopy((Object)((Object)chartDescriptor)));
    }

    protected ITimeRange getRange() {
        return this.m_newRange;
    }

    public void setSize(int width, int height) {
        this.m_size = new Point(Math.max(1, width), Math.max(1, height));
    }

    protected Point getSize() {
        return this.m_size;
    }

    public void setRange(ITimeRange range) {
        this.m_newRange = range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FLRChartDescriptor createLocalChartDescriptor() {
        FLRChartDescriptor fLRChartDescriptor = this.m_descriptor;
        synchronized (fLRChartDescriptor) {
            return (FLRChartDescriptor)((Object)PersistenceToolkit.createCopy((Object)((Object)this.m_descriptor)));
        }
    }

    public void setEnabled(DataSeriesDescriptor dsd, boolean enabled) {
        if (enabled) {
            this.disabled.remove(dsd.getId());
        } else {
            this.disabled.add(dsd.getId());
        }
    }

    protected boolean getAllowChartSelection(FLRChartDescriptor chartDescriptor) {
        for (DataSeriesDescriptor dsd : chartDescriptor.getDataSeriesDescriptors()) {
            GraphConfig chartConfig = ChartModelBuilder.getGraphConfig(chartDescriptor.getXAxis(), dsd);
            if (chartConfig.allowSelection) continue;
            return false;
        }
        return true;
    }

    protected ITimeRange findRange(ITimeRange range, FLRChartDescriptor chart) {
        IView view = this.getView();
        view.setRange(range);
        HashSet<IEventType> allTypes = new HashSet<IEventType>();
        for (DataSeriesDescriptor dsd : chart.getDataSeriesDescriptors()) {
            allTypes.addAll(FLRDescriptorToolkit.createAcceptor(this.getServiceLocator(), dsd).getAcceptedSet());
        }
        view.setEventTypes(allTypes);
        String identifier = FLRDescriptorToolkit.getXDataSource(chart.getXAxis());
        if ("(duration)".equals(identifier)) {
            return this.findDurationRange(view);
        }
        return this.findXRange(view, identifier);
    }

    private ITimeRange findXRange(IView view, String identifier) {
        long max = Long.MIN_VALUE;
        for (IEvent e : view) {
            Object o = e.getValue(identifier);
            if (!(o instanceof Number)) continue;
            max = Math.max(((Number)o).longValue(), max);
        }
        if (max == Long.MIN_VALUE) {
            return new TimeRange(0L, 1L);
        }
        return new TimeRange(0L, max);
    }

    private ITimeRange findDurationRange(IView view) {
        long max = Long.MIN_VALUE;
        for (IEvent e : view) {
            max = Math.max(e.getDuration(), max);
        }
        if (max == Long.MIN_VALUE) {
            return new TimeRange(0L, 1000000000L);
        }
        return new TimeRange(0L, max);
    }

    private YAxisDescriptor getAxisDescriptor(FLRChartDescriptor cd, YAxis y) {
        if (y.getPosition() == YAxis.Position.LEFT) {
            return cd.getLeftYAxis();
        }
        return cd.getRightYAxis();
    }

    protected DataSeriesProvider<ITimestampedData> createDataProvider(List<DataSeriesDescriptor> descriptors, XAxisDescriptor xAxis) {
        ArrayList<FLRDataSeries> series = new ArrayList<FLRDataSeries>();
        for (DataSeriesDescriptor descriptor : descriptors) {
            GraphConfig gc = ChartModelBuilder.getGraphConfig(xAxis, descriptor);
            series.add(new FLRDataSeries(this.getServiceLocator(), this.getView(), gc, descriptor));
        }
        return new SeriesProvider((DataSeries[])series.toArray(new FLRDataSeries[series.size()]));
    }

    public DefaultXYGreyChart<ITimestampedData> createNewCharto(FLRChartDescriptor chartDescriptor, ITimeRange range) {
        ArrayList<DataSeriesDescriptor> leftDescriptors = new ArrayList<DataSeriesDescriptor>();
        for (DataSeriesDescriptor descriptor : chartDescriptor.getLeftYAxis().getDataSeries()) {
            if (this.disabled.contains(descriptor.getId())) continue;
            leftDescriptors.add(descriptor);
        }
        ArrayList<DataSeriesDescriptor> rightDescriptors = new ArrayList<DataSeriesDescriptor>();
        for (DataSeriesDescriptor descriptor : chartDescriptor.getRightYAxis().getDataSeries()) {
            if (this.disabled.contains(descriptor.getId())) continue;
            rightDescriptors.add(descriptor);
        }
        ArrayList<DataSeriesDescriptor> allDsd = new ArrayList<DataSeriesDescriptor>();
        allDsd.addAll(leftDescriptors);
        allDsd.addAll(rightDescriptors);
        DataSeriesProvider<ITimestampedData> tProvider = this.createDataProvider(allDsd, chartDescriptor.getXAxis());
        DefaultXYGreyChart<ITimestampedData> chart = ChartModelBuilder.createChart();
        NanosXAxis nanosAxis = new NanosXAxis(chart);
        XAxisDescriptor xAxisDescriptor = chartDescriptor.getXAxis();
        chart.getPlotRenderer().setExtrapolateMissingData(chartDescriptor.getXAxis().getExtrapolateMissingData());
        nanosAxis.setPaintGridLinesEnabled(xAxisDescriptor.getShowGridLines());
        nanosAxis.setTickMarksEnabled(xAxisDescriptor.getShowTickMarks());
        nanosAxis.setVisible(xAxisDescriptor.getVisible());
        nanosAxis.setTitle(xAxisDescriptor.getTitle());
        nanosAxis.setRange((Number)range.getStartTimestamp(), (Number)range.getEndTimestamp());
        if (this.hasTimeStampXAxis(chartDescriptor)) {
            TimestampFormatter ntf = TimestampFormatter.createNanoTimestampFormatter();
            nanosAxis.setFormatter((TickFormatter)ntf);
        } else {
            nanosAxis.setFormatter((TickFormatter)new FieldFormatter(chartDescriptor.getXAxis().getUnit()));
            nanosAxis.setTitle(chartDescriptor.getXAxis().getTitle());
        }
        chart.setXAxis((XAxis)nanosAxis);
        YAxis[] yaxis = chart.getYAxis();
        YAxis leftYAxis = null;
        YAxis rightYAxis = null;
        YAxis[] yAxisArray = yaxis;
        int n = yaxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            YAxisDescriptor axisDescriptor = this.getAxisDescriptor(chartDescriptor, y);
            y.setTitle(axisDescriptor.getTitle());
            y.setVisible(axisDescriptor.getVisible());
            y.setMinimumWidth(axisDescriptor.getMinimumWidth());
            ((DefaultYAxis)y).setPaintGridLinesEnabled(axisDescriptor.getShowGridLines());
            ((DefaultYAxis)y).setTickMarksEnabled(axisDescriptor.getShowTickMarks());
            ((DefaultYAxis)y).setNumberOfTicks(6);
            ((DefaultYAxis)y).setTitleLegendEnabled(axisDescriptor.getShowTitleLegend());
            ((DefaultYAxis)y).setAlwaysShowZero(axisDescriptor.getAlwaysShowZero());
            ((DefaultYAxis)y).setAutoPadding(axisDescriptor.getAutoPad() ? 0.1 : 0.0);
            ((DefaultYAxis)y).setFormatter((TickFormatter)new FieldFormatter(axisDescriptor.getUnit()));
            ((DefaultYAxis)y).setContentType(this.getContentType(axisDescriptor.getUnit()));
            ((DefaultYAxis)y).setTickDensity(axisDescriptor.getTickDensity());
            if (axisDescriptor.getUnit().getDisplayUnit().getContentType().equals(UnitLookup.PERCENTAGE)) {
                ((DefaultYAxis)y).setAutoRangeEnabled(false);
                ((DefaultYAxis)y).setRange((Number)0, (Number)1);
                ((DefaultYAxis)y).setNumberOfTicks(5);
            }
            if (y.getPosition() == YAxis.Position.LEFT) {
                leftYAxis = y;
            } else if (y.getPosition() == YAxis.Position.RIGHT) {
                rightYAxis = y;
            }
            ++n2;
        }
        chart.setMetaDataProvider((SeriesMetaDataProvider)new FlrSeriesMetaDataProvider(chartDescriptor, leftYAxis, rightYAxis));
        chart.setXAxis(chart.getXAxis());
        chart.setDataProvider(tProvider);
        return chart;
    }

    protected boolean hasTimeStampXAxis(FLRChartDescriptor chartDescriptor) {
        for (DataSeriesDescriptor dsd : chartDescriptor.getDataSeriesDescriptors()) {
            if (dsd.getStyle() != Style.DISTRIBUTION && dsd.getStyle() != Style.COUNT_LESS_THAN) continue;
            return false;
        }
        return true;
    }

    private String getContentType(UnitDescriptor unit) {
        if (unit.getDisplayUnit().getContentType().equals(UnitLookup.MEMORY)) {
            return "bytes";
        }
        if (unit.getDisplayUnit().getContentType().equals(UnitLookup.COUNT) || unit.getDisplayUnit().getContentType().equals(UnitLookup.INDEX)) {
            return "count";
        }
        if (unit.getDisplayUnit().getContentType().equals(UnitLookup.TIMESTAMP) || unit.getDisplayUnit().getContentType().equals(UnitLookup.TIMESPAN)) {
            return "time";
        }
        return "unknown";
    }

    private static DefaultXYGreyChart<ITimestampedData> createChart() {
        DefaultXYGreyChart chart = new DefaultXYGreyChart();
        chart.setXAxis((XAxis)ChartModelBuilder.createNanoAxis((DefaultXYGreyChart<ITimestampedData>)chart));
        chart.addYAxis((YAxis)ChartModelBuilder.createYAxis((DefaultXYGreyChart<ITimestampedData>)chart, YAxis.Position.LEFT));
        chart.addYAxis((YAxis)ChartModelBuilder.createYAxis((DefaultXYGreyChart<ITimestampedData>)chart, YAxis.Position.RIGHT));
        chart.setAntialiasingEnabled(true);
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 5));
        chart.setAutoUpdateOnAxisChange(true);
        chart.setAntialiasingEnabled(ChartModelBuilder.isUsingAntialiasing());
        return chart;
    }

    private static boolean isUsingAntialiasing() {
        return UIPlugin.getDefault().getPreferenceStore().getBoolean("graphics.antialiasing");
    }

    private static DefaultYAxis createYAxis(DefaultXYGreyChart<ITimestampedData> chart, YAxis.Position position) {
        DefaultYAxis yAxis = new DefaultYAxis(chart);
        yAxis.setMin(null);
        yAxis.setMax(null);
        yAxis.setAutoPadding(0.1);
        yAxis.setAutoRangeEnabled(true);
        yAxis.setPosition(position);
        return yAxis;
    }

    private static NanosXAxis createNanoAxis(DefaultXYGreyChart<ITimestampedData> chart) {
        NanosXAxis nan = new NanosXAxis(chart);
        nan.setTickMarksEnabled(true);
        nan.setPaintGridLinesEnabled(true);
        return nan;
    }

    public static GraphConfig getGraphConfig(XAxisDescriptor x, DataSeriesDescriptor y) {
        GraphConfig c = new GraphConfig();
        switch (y.getStyle()) {
            case DENSITY: {
                c.name = Style.DENSITY.name();
                c.renderingMode = RenderingMode.DENSITY;
                c.yIdentifier = FLRDescriptorToolkit.getYDataSource(y);
                c.xIdentifier = "(endTime)";
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case NORMAL: {
                c.name = Style.NORMAL.name();
                c.renderingMode = RenderingMode.SUBSAMPLING;
                c.yIdentifier = FLRDescriptorToolkit.getYDataSource(y);
                c.xIdentifier = "(endTime)";
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case BAR: {
                c.name = Style.BAR.name();
                c.renderingMode = RenderingMode.SUBSAMPLING;
                c.yIdentifier = FLRDescriptorToolkit.getYDataSource(y);
                c.xIdentifier = "";
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case AVERAGING: {
                c.name = Style.AVERAGING.name();
                c.renderingMode = RenderingMode.AVERAGING;
                c.xIdentifier = "(endTime)";
                c.yIdentifier = FLRDescriptorToolkit.getYDataSource(y);
                c.eventOrder = EventOrder.ASCENDING;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case INTEGRATING: {
                c.name = Style.INTEGRATING.name();
                c.renderingMode = RenderingMode.INTEGRATING;
                c.xIdentifier = "(startTime)";
                c.yIdentifier = FLRDescriptorToolkit.getYDataSource(y);
                c.eventOrder = EventOrder.ASCENDING;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case DENSITY_INTEGRATING: {
                c.name = Style.DENSITY_INTEGRATING.name();
                c.renderingMode = RenderingMode.DENSITY_INTEGRATING;
                c.yIdentifier = "(duration)";
                c.xIdentifier = "(startTime)";
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.EXPANDED;
                c.allowSelection = true;
                break;
            }
            case DISTRIBUTION: {
                c.name = Style.DISTRIBUTION.name();
                c.renderingMode = RenderingMode.DENSITY;
                c.yIdentifier = "(duration)";
                c.xIdentifier = FLRDescriptorToolkit.getXDataSource(x);
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.NORMAL;
                c.allowSelection = false;
                break;
            }
            case COUNT_LESS_THAN: {
                c.name = Style.COUNT_LESS_THAN.name();
                c.renderingMode = RenderingMode.DENSITY_INTEGRATING;
                c.yIdentifier = FLRDescriptorToolkit.getXDataSource(x);
                c.xIdentifier = FLRDataSeries.ZERO_FIELD.getIdentifier();
                c.eventOrder = EventOrder.ANY;
                c.expansion = Expansion.NORMAL;
                c.allowSelection = false;
            }
        }
        return c;
    }
}

