/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.ant;

import com.sun.javafx.tools.ant.FileSet;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.DeployParams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.tools.ant.types.resources.FileResource;
import sun.misc.BASE64Encoder;

public final class Utils {
    private Utils() {
    }

    public static void addResources(CommonParams commonParams, org.apache.tools.ant.types.FileSet fileSet) {
        for (FileResource fileResource : fileSet) {
            commonParams.addResource(fileResource.getBaseDir(), fileResource.getFile());
        }
    }

    public static void addResources(DeployParams deployParams, org.apache.tools.ant.types.FileSet fileSet, String string) {
        for (FileResource fileResource : fileSet) {
            deployParams.addResource(fileResource.getBaseDir(), fileResource.getFile(), string);
        }
    }

    public static void addResources(DeployParams deployParams, FileSet fileSet) {
        Iterator iterator = fileSet.iterator();
        while (iterator.hasNext()) {
            FileResource fileResource = (FileResource)iterator.next();
            deployParams.addResource(fileResource.getBaseDir(), fileResource.getFile(), fileSet.getMode(), fileSet.getTypeAsString(), fileSet.getOs(), fileSet.getArch());
        }
    }

    public static void readFully(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[10000];
        while (inputStream.read(byArray) != -1) {
        }
    }

    public static void readAllFully(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            Utils.readFully(jarFile.getInputStream(jarEntry));
        }
    }

    public static byte[] getBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String getBase64Encoded(CertPath certPath) throws CertificateEncodingException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(certPath.getEncoded());
    }
}

