/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregator;
import org.apache.derby.impl.sql.execute.ScalarAggregateResultSet;

class DistinctScalarAggregateResultSet
extends ScalarAggregateResultSet {
    private ColumnOrdering[] order;
    private int maxRowSize;
    private boolean dropDistinctAggSort;
    private long sortId;
    private ScanController scanController;
    private ExecIndexRow sortResultRow;
    private boolean sorted;

    DistinctScalarAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n, int n2, Activation activation, int n3, int n4, int n5, boolean bl2, double d, double d2) throws StandardException {
        super(noPutResultSet, bl, n, activation, n3, n5, bl2, d, d2);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n2)).getArray(ColumnOrdering[].class);
        this.maxRowSize = n4;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sortResultRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        try {
            this.scanController = this.loadSorter();
        }
        catch (StandardException standardException) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw standardException;
        }
        this.sorted = true;
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecIndexRow execIndexRow = null;
        ExecIndexRow execIndexRow2 = null;
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(bl)) != null) {
                if (execIndexRow2 == null) {
                    bl = false;
                    execIndexRow2 = (ExecIndexRow)execIndexRow.getClone();
                    continue;
                }
                this.accumulateScalarAggregation(execIndexRow, execIndexRow2, true);
            }
            if (this.countOfRows == 0) {
                execIndexRow2 = this.finishAggregation(execIndexRow2);
                this.setCurrentRow(execIndexRow2);
                ++this.countOfRows;
            }
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execIndexRow2;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.scanController != null) {
            this.scanController.close();
            this.scanController = null;
        }
        this.source.reopenCore();
        this.scanController = this.loadSorter();
        this.sorted = true;
        ++this.numOpens;
        this.countOfRows = 0;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        this.closeSource();
    }

    @Override
    public ExecIndexRow getRowFromResultSet(boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        if (this.scanController.next()) {
            this.currentRow = bl ? this.sortResultRow.getClone() : this.sortResultRow;
            execIndexRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(execIndexRow.getRowArray());
        }
        return execIndexRow;
    }

    protected void closeSource() throws StandardException {
        if (this.scanController != null) {
            if (this.dropDistinctAggSort) {
                try {
                    this.getTransactionController().dropSort(this.sortId);
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.dropDistinctAggSort = false;
            }
            this.scanController.close();
            this.scanController = null;
        }
        this.source.close();
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow execRow;
        ExecIndexRow execIndexRow = this.getRowTemplate();
        int n = (int)this.optimizerEstimatedRowCount;
        TransactionController transactionController = this.getTransactionController();
        GenericAggregator[] genericAggregatorArray = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
        AggregateSortObserver aggregateSortObserver = new AggregateSortObserver(true, genericAggregatorArray, this.aggregates, execIndexRow);
        this.sortId = transactionController.createSort(null, execIndexRow.getRowArray(), this.order, aggregateSortObserver, false, n, this.maxRowSize);
        SortController sortController = transactionController.openSort(this.sortId);
        this.dropDistinctAggSort = true;
        while ((execRow = this.source.getNextRowCore()) != null) {
            sortController.insert(execRow.getRowArray());
            ++this.rowsInput;
        }
        sortController.completedInserts();
        this.scanController = transactionController.openSortScan(this.sortId, this.activation.getResultSetHoldability());
        n = this.rowsInput;
        return this.scanController;
    }
}

