/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui;

import com.jrockit.mc.ui.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.misc.ExceptionDialog;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class WorkbenchToolkit {
    public static void asyncOpenEditor(final IPathEditorInput ei) {
        DisplayToolkit.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                WorkbenchToolkit.openEditor(ei);
            }
        });
    }

    public static void openEditor(IPathEditorInput ei) {
        WorkbenchToolkit.openEditor(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), ei);
    }

    public static void openEditor(IWorkbenchWindow window, IPathEditorInput ei) {
        IEditorDescriptor editorDesc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(ei.getPath().lastSegment());
        if (window == null) {
            ErrorDialog.showError(Messages.COULD_NOT_OPEN_EDITOR, Messages.WORKBENCH_WINDOW_NOT_AVAILABLE);
            UIPlugin.getDefault().getLogger().severe("Workbench Window not available");
        } else if (editorDesc == null) {
            ErrorDialog.showError(Messages.COULD_NOT_OPEN_EDITOR, NLS.bind((String)Messages.NO_ASSOCIATED_EDITOR, (Object)ei.getName()));
            UIPlugin.getDefault().getLogger().severe("Editor not found for " + ei.getName());
        } else {
            try {
                window.getActivePage().openEditor((IEditorInput)ei, editorDesc.getId());
            }
            catch (PartInitException e) {
                ExceptionDialog.openExceptionDialog(Messages.COULD_NOT_OPEN_EDITOR, e.getLocalizedMessage(), e);
                UIPlugin.getDefault().getLogger().log(Level.SEVERE, "Failed to open " + editorDesc.getId(), e);
            }
        }
    }
}

