/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.applet2.Applet2Context;
import com.sun.applet2.Applet2Host;
import com.sun.deploy.trace.Trace;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import netscape.javascript.JSObject;
import sun.plugin2.applet2.Plugin2Host;

public class DeployPerfLogger {
    private static Applet2Context ctx;
    private static boolean gotError;
    private static final List<Record> queue;
    private static boolean PERF_LOG_ENABLED;
    private static JSObject js;
    private static PerfLoggerThread logger;
    public static long lastReported;
    private static long firstReported;

    private static synchronized JSObject getJSObject() {
        Applet2Host applet2Host;
        if (js != null) {
            return js;
        }
        if (ctx != null && (applet2Host = ctx.getHost()) instanceof Plugin2Host) {
            try {
                js = ((Plugin2Host)applet2Host).getOneWayJSObject();
            }
            catch (Exception exception) {
                ctx = null;
            }
        }
        return js;
    }

    public static void setContext(Applet2Context applet2Context) {
        if (!PERF_LOG_ENABLED) {
            return;
        }
        ctx = applet2Context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushQueue() {
        boolean bl = true;
        JSObject jSObject = DeployPerfLogger.getJSObject();
        if (jSObject == null) {
            return;
        }
        while (bl) {
            Record record;
            List<Record> list = queue;
            synchronized (list) {
                record = !queue.isEmpty() ? queue.remove(0) : null;
            }
            if (record != null) {
                DeployPerfLogger.report(jSObject, record);
                continue;
            }
            bl = false;
        }
    }

    private static void report(JSObject jSObject, Record record) {
        long l = System.nanoTime();
        long l2 = (record.tm - l) / 1000000L;
        String string = record.label;
        if (lastReported == 0L) {
            firstReported = l;
        }
        if (lastReported != 0L) {
            string = "[" + (l - firstReported + 500000L) / 1000000L + " ms" + "(delta=" + (l - lastReported + 500000L) / 1000000L + ")] " + string;
        }
        Trace.println((String)("PERFLOG: report [" + string + "]"));
        jSObject.eval("if (typeof perfLog == 'function') {    perfLog(" + l2 + ", '" + string + "');}");
        lastReported = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timestamp(String string) {
        long l = System.nanoTime();
        if (PERF_LOG_ENABLED && logger != null && logger.isActive()) {
            List<Record> list = queue;
            synchronized (list) {
                queue.add(new Record(l, string));
                queue.notifyAll();
            }
        }
    }

    static {
        gotError = false;
        queue = new LinkedList<Record>();
        PERF_LOG_ENABLED = false;
        js = null;
        logger = null;
        boolean bl = false;
        try {
            bl = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    return "true".equals(System.getProperty("jnlp.fx.perf"));
                }
            });
            if (bl) {
                logger = new PerfLoggerThread();
            }
            PERF_LOG_ENABLED = bl;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored((Throwable)privilegedActionException);
        }
        lastReported = 0L;
        firstReported = 0L;
    }

    static class PerfLoggerThread
    extends Thread {
        private boolean isActive = true;

        synchronized boolean isActive() {
            return this.isActive;
        }

        public PerfLoggerThread() {
            super("Deploy Perf Logger");
            this.setDaemon(true);
            if (PERF_LOG_ENABLED) {
                Trace.println((String)"Starting perf tracing thread");
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                boolean bl = true;
                long l = System.currentTimeMillis();
                while (bl) {
                    if (DeployPerfLogger.getJSObject() != null) {
                        try {
                            DeployPerfLogger.flushQueue();
                            gotError = false;
                        }
                        catch (Exception exception) {
                            if (gotError) {
                                bl = false;
                                Trace.ignoredException((Exception)exception);
                            } else {
                                gotError = true;
                            }
                            Class<DeployPerfLogger> clazz = DeployPerfLogger.class;
                            // MONITORENTER : com.sun.deploy.uitoolkit.impl.fx.DeployPerfLogger.class
                            js = null;
                            // MONITOREXIT : clazz
                        }
                    } else if (System.currentTimeMillis() - l > 5000L) {
                        Trace.println((String)"Stop perf tracing as could not get JS object");
                        bl = false;
                    }
                    List list = queue;
                    // MONITORENTER : list
                    try {
                        queue.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = false;
                    }
                }
                PerfLoggerThread perfLoggerThread = this;
            }
            catch (Throwable throwable) {
                try {
                    Trace.ignored((Throwable)throwable);
                    PerfLoggerThread perfLoggerThread = this;
                }
                catch (Throwable throwable2) {
                    PerfLoggerThread perfLoggerThread = this;
                    // MONITORENTER : perfLoggerThread
                    this.isActive = false;
                    // MONITOREXIT : perfLoggerThread
                    throw throwable2;
                }
                this.isActive = false;
                // MONITOREXIT : perfLoggerThread
                return;
            }
            // MONITORENTER : perfLoggerThread
            this.isActive = false;
            // MONITOREXIT : perfLoggerThread
            return;
        }
    }

    static class Record {
        long tm;
        String label;

        public Record(long l, String string) {
            this.tm = l;
            this.label = string;
        }
    }
}

