/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.windows;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WindowsBundlerParam<T>
extends StandardBundlerParam<T> {
    private static final ResourceBundle I18N;
    public static final BundlerParamInfo<String> INSTALLER_FILE_NAME;
    public static final BundlerParamInfo<String> APP_REGISTRY_NAME;
    public static final StandardBundlerParam<String> MENU_GROUP;
    public static final StandardBundlerParam<Boolean> BIT_ARCH_64;
    public static final StandardBundlerParam<Boolean> BIT_ARCH_64_RUNTIME;
    public static final BundlerParamInfo<JreUtils.Rule[]> WIN_JRE_RULES;
    public static final BundlerParamInfo<RelativeFileSet> WIN_RUNTIME;

    public WindowsBundlerParam(String string, String string2, String string3, Class<T> clazz, Function<Map<String, ? super Object>, T> function, BiFunction<String, Map<String, ? super Object>, T> biFunction) {
        super(string, string2, string3, clazz, function, biFunction);
    }

    public static void extractFlagsFromRuntime(Map<String, ? super Object> map) {
        String string;
        if (map.containsKey(".runtime.autodetect")) {
            return;
        }
        map.put(".runtime.autodetect", "attempted");
        RelativeFileSet relativeFileSet = WIN_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            string = "java version \"" + System.getProperty("java.version") + "\"\n" + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")\n";
        } else {
            File file = relativeFileSet.getBaseDirectory();
            File file2 = new File(file, "bin\\java");
            ProcessBuilder processBuilder = new ProcessBuilder(file2.getAbsolutePath(), "-version");
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (PrintStream printStream = new PrintStream(byteArrayOutputStream);){
                    IOUtils.exec(processBuilder, Log.isDebug(), true, printStream);
                }
                string = byteArrayOutputStream.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                map.put(".runtime.autodetect", "failed");
                return;
            }
        }
        WindowsBundlerParam.extractFlagsFromVersion(map, string);
        map.put(".runtime.autodetect", "succeeded");
    }

    public static void extractFlagsFromVersion(Map<String, ? super Object> map, String string) {
        Pattern pattern = Pattern.compile("(\\d*)[- ]?[bB]it");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            map.put(".runtime.bit-arch", matcher.group(1));
        } else {
            map.put(".runtime.bit-arch", "32");
        }
        Pattern pattern2 = Pattern.compile("java version \"((\\d+.\\d+.\\d+)_(\\d+))(-(.*))?\"");
        matcher = pattern2.matcher(string);
        if (matcher.find()) {
            map.put(".runtime.version", matcher.group(1));
            map.put(".runtime.version.release", matcher.group(2));
            map.put(".runtime.version.update", matcher.group(3));
            map.put(".runtime.version.modifiers", matcher.group(5));
        } else {
            map.put(".runtime.version", "");
            map.put(".runtime.version.release", "");
            map.put(".runtime.version.update", "");
            map.put(".runtime.version.modifiers", "");
        }
    }

    private static /* synthetic */ RelativeFileSet lambda$static$190(String string, Map map) {
        return JreUtils.extractJreAsRelativeFileSet(string, WIN_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ RelativeFileSet lambda$static$189(Map map) {
        return JreUtils.extractJreAsRelativeFileSet(System.getProperty("java.home"), WIN_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ JreUtils.Rule[] lambda$static$188(String string, Map map) {
        return null;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

