/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class MacAppStoreBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacAppStoreBundler.class.getName());
    private static final String TEMPLATE_BUNDLE_ICON_HIDPI = "GenericAppHiDPI.icns";
    private static final String DEFAULT_ENTITLEMENTS = "MacAppStore.entitlements";
    private static final String DEFAULT_INHERIT_ENTITLEMENTS = "MacAppStore_Inherit.entitlements";
    public static final BundlerParamInfo<String> MAC_APP_STORE_APP_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-app.name"), I18N.getString("param.signing-key-app.description"), "mac.signing-key-app", String.class, map -> MacBaseInstallerBundler.findKey("3rd Party Mac Developer Application: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)map), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)map)), (string, map) -> string);
    public static final BundlerParamInfo<String> MAC_APP_STORE_PKG_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-pkg.name"), I18N.getString("param.signing-key-pkg.description"), "mac.signing-key-pkg", String.class, map -> MacBaseInstallerBundler.findKey("3rd Party Mac Developer Installer: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)map), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)map)), (string, map) -> string);
    public static final StandardBundlerParam<File> MAC_APP_STORE_ENTITLEMENTS = new StandardBundlerParam<File>(I18N.getString("param.mac-app-store-entitlements.name"), I18N.getString("param.mac-app-store-entitlements.description"), "mac.app-store-entitlements", File.class, map -> null, (string, map) -> new File((String)string));

    public MacAppStoreBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        Log.info(MessageFormat.format(I18N.getString("message.building-bundle"), StandardBundlerParam.APP_NAME.fetchFrom(map)));
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
        }
        if (!file.canWrite()) {
            throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
        }
        map.put(MacAppBundler.DEFAULT_ICNS_ICON.getID(), TEMPLATE_BUNDLE_ICON_HIDPI);
        map.put(MacAppBundler.MAC_RULES.getID(), (Object)MacAppStoreBundler.createMacAppStoreRuntimeRules(map));
        File file2 = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(map);
        file2.mkdirs();
        map.put(MacAppBundler.DEVELOPER_ID_APP_SIGNING_KEY.getID(), null);
        File file3 = this.prepareAppBundle(map);
        this.prepareEntitlements(map);
        String string = MAC_APP_STORE_APP_SIGNING_KEY.fetchFrom(map);
        String string2 = MacAppBundler.BUNDLE_ID_SIGNING_PREFIX.fetchFrom(map);
        String string3 = this.getConfig_Entitlements(map).toString();
        String string4 = this.getConfig_Inherit_Entitlements(map).toString();
        MacAppStoreBundler.signAppBundle(map, file3, string, string2, string3, string4);
        File file4 = new File(file, (String)INSTALLER_NAME.fetchFrom(map) + "-MacAppStore.pkg");
        file.mkdirs();
        ProcessBuilder processBuilder = new ProcessBuilder("productbuild", "--component", file3.toString(), "/Applications", "--sign", MAC_APP_STORE_PKG_SIGNING_KEY.fetchFrom(map), "--product", file3 + "/Contents/Info.plist", file4.getAbsolutePath());
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        File file5 = file4;
        try {
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), file2.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.cleanupConfigFiles(map);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file5;
        catch (Exception exception) {
            File file6;
            try {
                Log.info("App Store Ready Bundle failed : " + exception.getMessage());
                exception.printStackTrace();
                Log.debug(exception);
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), file2.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.cleanupConfigFiles(map);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("mesasge.intermediate-bundle-location"), file2.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.cleanupConfigFiles(map);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file6;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (this.getConfig_Entitlements(map) != null) {
            this.getConfig_Entitlements(map).delete();
        }
        if (this.getConfig_Inherit_Entitlements(map) != null) {
            this.getConfig_Inherit_Entitlements(map).delete();
        }
        if (MAC_APP_IMAGE.fetchFrom(map) == null) {
            ((MacAppBundler)APP_BUNDLER.fetchFrom(map)).cleanupConfigFiles(map);
        }
    }

    private File getConfig_Entitlements(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".entitlements");
    }

    private File getConfig_Inherit_Entitlements(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "_Inherit.entitlements");
    }

    private void prepareEntitlements(Map<String, ? super Object> map) throws IOException {
        File file = (File)MAC_APP_STORE_ENTITLEMENTS.fetchFrom(map);
        if (file == null || !file.exists()) {
            this.fetchResource(this.getEntitlementsFileName(map), I18N.getString("resource.mac-app-store-entitlements"), DEFAULT_ENTITLEMENTS, this.getConfig_Entitlements(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        } else {
            this.fetchResource(this.getEntitlementsFileName(map), I18N.getString("resource.mac-app-store-entitlements"), file, this.getConfig_Entitlements(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        }
        this.fetchResource(this.getInheritEntitlementsFileName(map), I18N.getString("resource.mac-app-store-inherit-entitlements"), DEFAULT_INHERIT_ENTITLEMENTS, this.getConfig_Inherit_Entitlements(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
    }

    private String getEntitlementsFileName(Map<String, ? super Object> map) {
        return MacAppBundler.MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".entitlements";
    }

    private String getInheritEntitlementsFileName(Map<String, ? super Object> map) {
        return MacAppBundler.MAC_BUNDLER_PREFIX + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "_Inherit.entitlements";
    }

    public static JreUtils.Rule[] createMacAppStoreRuntimeRules(Map<String, ? super Object> map) {
        Object object;
        ArrayList<JreUtils.Rule> arrayList = new ArrayList<JreUtils.Rule>();
        arrayList.addAll(Arrays.asList(MacAppBundler.createMacRuntimeRules(map)));
        File file = map.containsKey(MacAppBundler.MAC_RUNTIME.getID()) ? ((object = map.get(MacAppBundler.MAC_RUNTIME.getID())) instanceof RelativeFileSet ? ((RelativeFileSet)object).getBaseDirectory() : new File(object.toString())) : new File(System.getProperty("java.home"));
        try {
            object = file.getCanonicalPath();
            if (((String)object).endsWith("/Contents/Home/jre")) {
                file = file.getParentFile().getParentFile().getParentFile();
            } else if (((String)object).endsWith("/Contents/Home")) {
                file = file.getParentFile().getParentFile();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (!file.exists()) {
            throw new RuntimeException(I18N.getString("error.non-existent-runtime"), new ConfigException(I18N.getString("error.non-existent-runtime"), I18N.getString("error.non-existent-runtime.advice")));
        }
        if (new File(file, "Contents/Home/lib/libjfxmedia_qtkit.dylib").exists() || new File(file, "Contents/Home/jre/lib/libjfxmedia_qtkit.dylib").exists()) {
            arrayList.add(JreUtils.Rule.suffixNeg("/lib/libjfxmedia_qtkit.dylib"));
        } else {
            arrayList.add(JreUtils.Rule.suffixNeg("/lib/libjfxmedia.dylib"));
        }
        return arrayList.toArray(new JreUtils.Rule[arrayList.size()]);
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "mac.appStore";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(this.getPKGBundleParameters());
        return linkedHashSet;
    }

    public Collection<BundlerParamInfo<?>> getPKGBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.remove(MacAppBundler.DEVELOPER_ID_APP_SIGNING_KEY);
        linkedHashSet.addAll(Arrays.asList(MAC_APP_STORE_APP_SIGNING_KEY, MAC_APP_STORE_ENTITLEMENTS, MAC_APP_STORE_PKG_SIGNING_KEY));
        return linkedHashSet;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (!System.getProperty("os.name").toLowerCase().contains("os x")) {
                throw new UnsupportedPlatformException();
            }
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            if (map.containsKey(MacAppBundler.MAC_RUNTIME.getID()) && map.get(MacAppBundler.MAC_RUNTIME.getID()) == null) {
                throw new ConfigException(I18N.getString("error.no-system-runtime"), I18N.getString("error.no-system-runtime.advice"));
            }
            map.put(MacAppBundler.MAC_RULES.getID(), (Object)MacAppStoreBundler.createMacAppStoreRuntimeRules(map));
            this.validateAppImageAndBundeler(map);
            if (!Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(map)).orElse(Boolean.TRUE).booleanValue()) {
                throw new ConfigException(I18N.getString("error.must-sign-app-store"), I18N.getString("error.must-sign-app-store.advice"));
            }
            if (MAC_APP_STORE_APP_SIGNING_KEY.fetchFrom(map) == null) {
                throw new ConfigException(I18N.getString("error.no-app-signing-key"), I18N.getString("error.no-app-signing-key.advice"));
            }
            if (MAC_APP_STORE_PKG_SIGNING_KEY.fetchFrom(map) == null) {
                throw new ConfigException(I18N.getString("error.no-pkg-signing-key"), I18N.getString("error.no-pkg-signing-key.advice"));
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }
}

