/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkHeader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkLoader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LoaderContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Executor;

public class StreamReader
implements Runnable {
    private final LoaderContext recordingLoader;
    private final InputStream stream;
    private Executor executor;

    public StreamReader(InputStream stream, LoaderContext recordingLoader, Executor executor) {
        this.recordingLoader = recordingLoader;
        this.stream = stream;
        this.executor = executor;
    }

    @Override
    public void run() {
        int chunkCount = 0;
        int chunkPos = 0;
        while (true) {
            BufferFiller buffer = new BufferFiller(this.recordingLoader.takeBuffer());
            try {
                if (buffer.data == null) {
                    return;
                }
                if (buffer.fillUpTo(ChunkHeader.CHUNK_HEAD_SIZE)) {
                    ChunkHeader ch = new ChunkHeader(buffer.data, chunkCount++, chunkPos);
                    buffer.fillUpTo(ch.getMetaDataOffset() + 4);
                    int metaDataLength = IntegerParser.readInt(buffer.data, ch.getMetaDataOffset());
                    int chunkSize = ch.getMetaDataOffset() + metaDataLength;
                    buffer.fillUpTo(chunkSize);
                    chunkPos += chunkSize;
                    this.executor.execute(new ChunkLoader(ch, buffer.data, this.recordingLoader));
                    continue;
                }
                this.recordingLoader.allChunksLoaded(chunkCount);
                this.recordingLoader.returnBuffer(buffer.data);
                return;
            }
            catch (Throwable e) {
                this.recordingLoader.returnBuffer(buffer.data);
                this.recordingLoader.setFailed(e);
                continue;
            }
            break;
        }
    }

    private class BufferFiller {
        byte[] data;
        int bufferFilledTo;

        BufferFiller(byte[] buffer) {
            this.data = buffer;
        }

        boolean fillUpTo(int fillUpto) throws IOException, InvalidFlrFileException {
            if (this.data.length < fillUpto) {
                this.data = Arrays.copyOf(this.data, (int)((double)fillUpto * 1.2));
            }
            while (this.bufferFilledTo < fillUpto) {
                int fillLength = fillUpto - this.bufferFilledTo;
                int read = StreamReader.this.stream.read(this.data, this.bufferFilledTo, fillLength);
                if (read < 0) {
                    if (this.bufferFilledTo == 0) {
                        return false;
                    }
                    throw new InvalidFlrFileException();
                }
                this.bufferFilledTo += read;
            }
            return true;
        }
    }
}

