/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.model.fields.TimeField;
import com.jrockit.mc.ui.model.fields.TimeSpanField;
import java.text.MessageFormat;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import se.hirt.greychart.impl.TimestampFormatter;

class XRangeRuler
extends Canvas {
    private static final int CHARS_IN_TIMESTAMP = 15;
    private static final int TICKS_PER_TIMESTAMP = 10;
    private static final int MARK_LINE_HEIGHT = 2;
    private int startPixel = 0;
    private int endMargin = 0;
    private final int baseLineYPos;
    private final int pixelStep;
    private long startInNs;
    private long endInNs;
    private long rangeInNs;
    private final TimestampFormatter formatter = TimestampFormatter.createNanoTimestampFormatter();
    private int firstDrawnX = Integer.MAX_VALUE;

    public XRangeRuler(Composite parent, int style, final long recStartNanos) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                XRangeRuler.this.paint(e);
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (e.x >= XRangeRuler.this.startPixel && e.x < XRangeRuler.this.getSize().x - XRangeRuler.this.endMargin) {
                    long NANOS_PER_MILLIS = 1000000L;
                    long time = XRangeRuler.this.getValueAtPixel(e.x - XRangeRuler.this.startPixel, XRangeRuler.this.getSize().x - XRangeRuler.this.endMargin - XRangeRuler.this.startPixel - 1);
                    long sinceRecordingStart = time - recStartNanos;
                    String timestamp = new TimeField(0).formatObject((Object)(time / NANOS_PER_MILLIS));
                    String sinceRecording = new TimeSpanField(0).formatObject((Object)(sinceRecordingStart / NANOS_PER_MILLIS));
                    XRangeRuler.this.setToolTipText(MessageFormat.format(Messages.XRANGE_RULER_TOOLTIP_X_Y_TEXT, timestamp, sinceRecording));
                }
            }
        });
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        FontMetrics fm = gc.getFontMetrics();
        this.baseLineYPos = fm.getHeight();
        this.pixelStep = (fm.getAverageCharWidth() + 4) * 15 / 10;
        gc.dispose();
    }

    public void setRange(long startInNs, long endInNs) {
        this.startInNs = startInNs;
        this.endInNs = endInNs;
        this.rangeInNs = endInNs - startInNs;
    }

    public int getHeight() {
        return this.baseLineYPos + 4 + 1;
    }

    public void setStartPixel(int pixelPos) {
        this.startPixel = pixelPos;
    }

    public void setEndMargin(int margin) {
        this.endMargin = margin;
    }

    public void paint(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        int width = rect.width - this.endMargin - this.startPixel - 1;
        if (width <= 1) {
            return;
        }
        Color c = new Color((Device)Display.getCurrent(), GraphHelper.DEFAULT_FOREGROUND_COLOR.getRGBColor());
        e.gc.setForeground(c);
        e.gc.drawLine(this.startPixel, this.baseLineYPos, this.startPixel + width, this.baseLineYPos);
        int stepNum = width / this.pixelStep;
        float decimalStep = (float)this.pixelStep + (float)(width % this.pixelStep) / (float)stepNum;
        this.firstDrawnX = Integer.MAX_VALUE;
        int markNum = 0;
        float currentPixel = 0.0f;
        while (Math.round(currentPixel) <= width) {
            int lineHeight = 2;
            if (markNum++ % 10 == 0) {
                lineHeight = 4;
                this.drawText(e.gc, this.getValueAtPixel(currentPixel, width), Math.round(currentPixel) + this.startPixel, 0);
            }
            e.gc.drawLine(Math.round(currentPixel) + this.startPixel, this.baseLineYPos, Math.round(currentPixel) + this.startPixel, this.baseLineYPos + lineHeight);
            currentPixel += decimalStep;
        }
        c.dispose();
    }

    private int getTextWidth(GC gc, String text) {
        int textWidth = 0;
        int i = 0;
        while (i < text.length()) {
            textWidth += gc.getCharWidth(text.charAt(i));
            ++i;
        }
        return textWidth;
    }

    private long getValueAtPixel(double pixel, int width) {
        double percentageOfRange = pixel / (double)width;
        long fractionInNs = (long)((double)this.rangeInNs * percentageOfRange);
        return fractionInNs + this.startInNs;
    }

    private void drawText(GC gc, long nanos, int midX, int y) {
        String val = this.formatter.format(nanos, this.startInNs, this.endInNs);
        int textWidth = this.getTextWidth(gc, val);
        int x = midX - textWidth / 2;
        gc.drawText(val, x, 0);
        if (x < this.firstDrawnX) {
            this.firstDrawnX = x;
        }
    }
}

