/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.dial;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.dial.DialInformationProvider;
import com.jrockit.mc.ui.dial.DialInformationViewer;
import com.jrockit.mc.ui.dial.DialViewer;
import com.jrockit.mc.ui.dial.FixedDial;
import com.jrockit.mc.ui.dial.IDialInformationProvider;
import com.jrockit.mc.ui.dial.IDialProvider;
import com.jrockit.mc.ui.dial.MovingDial;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.rate.RefreshController;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class DialComponent
extends AbstractUIComponent
implements INavigatorSelectionChangeListener,
IOperativeSetAware,
ITypeVisibilitySupport {
    private RefreshController m_refreshController;

    public boolean initialize(IServiceLocator serviceLocator) {
        boolean initOK = super.initialize(serviceLocator);
        InformationModelBuilder<DialDescriptor> imb = new InformationModelBuilder<DialDescriptor>(serviceLocator, this.getDialDescriptors(), this.getComponentDescriptor(), this.getRepository().getUnit().getDerivative());
        imb.setEventView(this.createView());
        imb.setOperativeSetEnabled(false);
        serviceLocator.registerService(imb);
        return initOK;
    }

    protected InformationModelBuilder<DialDescriptor> getBuilder() {
        return (InformationModelBuilder)this.getServiceLocator().getService(InformationModelBuilder.class);
    }

    private List<DialDescriptor> getDialDescriptors() {
        return this.getRepository().getDialDescriptors();
    }

    public boolean supportsToolbar() {
        return false;
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.m_refreshController.stop();
        this.getBuilder().stop();
        return super.dispose(serviceLocator);
    }

    public Control createPart(Composite parent) {
        this.m_refreshController = RefreshController.createGroup((Display)parent.getDisplay());
        Composite client = this.getFormToolkit().createComposite(parent, 0);
        client.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        MCAccessibleListener cp = new MCAccessibleListener();
        cp.setComponentType(AccessibilityConstants.COMPONENT_TYPE_DIAL);
        cp.setName(this.getComponentDescriptor().getName());
        client.getAccessible().addAccessibleListener((AccessibleListener)cp);
        client.setLayout((Layout)this.createLayout());
        if (this.getRepository().getAllowOperariveSet()) {
            Button button = this.createAllowOperativeSetButton(client, this.getFormToolkit());
            button.setLayoutData((Object)new GridData(131072, 128, true, false));
        }
        DialViewer viewer = this.createDialViewer(client);
        viewer.setLayoutData((Object)new GridData(4, 1024, true, true));
        if (this.getBuilder().getView().iterator().hasNext()) {
            DialInformationViewer dialInformationViewer = this.createDialInformationViewer(client);
            dialInformationViewer.setLayoutData((Object)new GridData(4, 128, true, false));
            this.addDials(viewer, dialInformationViewer);
        } else {
            CLabel l = new CLabel(client, 0x1000000);
            this.getFormToolkit().adapt((Composite)l);
            FocusTracker.enableFocusTracking((Composite)l);
            l.setLayoutData((Object)new GridData(4, 128, true, false));
            l.setText(Messages.DIAL_COMPONENT_NO_VALUE_TEXT);
        }
        return client;
    }

    private Button createAllowOperativeSetButton(Composite parent, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DialComponent.this.getBuilder().scheduleRebuild();
            }
        });
        return button;
    }

    private GridLayout createLayout() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public void hide() {
        this.m_refreshController.stop();
    }

    public void show() {
        super.show();
        this.m_refreshController.start();
    }

    protected void refresh() {
        this.getBuilder().scheduleRebuild();
    }

    private IView createView() {
        IView view = ((FlightRecording)this.getServiceLocator().getService(FlightRecording.class)).createView();
        view.setEventTypes(new EventTypeAcceptor(this.getServiceLocator(), this.getRepository().getEventTypeDescriptorBase()).getAcceptedSet());
        return view;
    }

    protected void initializeUI() {
        super.initializeUI();
        this.getBuilder().getView().setRange((ITimeRange)new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp()));
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    @Override
    public void onChange(long startTime, long endTime) {
        this.getBuilder().getView().setRange((ITimeRange)new TimeRange(startTime, endTime));
        this.markDirty();
    }

    private DialInformationViewer createDialInformationViewer(final Composite client) {
        final DialInformationViewer diw = new DialInformationViewer(client, this.getFormToolkit(), 0);
        this.getBuilder().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Map values = (Map)DialComponent.this.getBuilder().getModel();
                for (Map.Entry entry : values.entrySet()) {
                    diw.setInput((String)entry.getKey(), entry.getValue());
                }
                DisplayToolkit.safeAsyncExec((Widget)client, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        diw.refresh();
                    }
                });
            }
        });
        this.getFormToolkit().adapt((Composite)diw);
        return diw;
    }

    public DialDescriptorRepository getRepository() {
        return (DialDescriptorRepository)this.getComponentSettings().getChildObject("dialDescriptorRepository", DialDescriptorRepository.class);
    }

    private DialViewer createDialViewer(Composite parent) {
        DialViewer viewer = new DialViewer(parent, 0);
        this.getFormToolkit().adapt((Composite)viewer);
        viewer.setToolTipText(this.getComponentDescriptor().getDescription());
        viewer.setTitle(this.getComponentDescriptor().getName());
        IUnit unit = this.getRepository().getUnit().getUnit();
        viewer.setUnit(unit);
        viewer.setGradientRange(unit.quantity(this.getRepository().getGradientBeginValue()), unit.quantity(this.getRepository().getGradientEndValue()), this.getRepository().getGradientBeginColor(), this.getRepository().getGradientEndColor());
        this.hookModelDialViewer(viewer);
        FocusTracker.enableFocusTracking((Composite)viewer);
        this.m_refreshController.add((IRefreshable)viewer);
        return viewer;
    }

    private void hookModelDialViewer(final DialViewer viewer) {
        this.getBuilder().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Map values = (Map)DialComponent.this.getBuilder().getModel();
                for (Map.Entry entry : values.entrySet()) {
                    viewer.setInput((String)entry.getKey(), entry.getValue());
                }
                DisplayToolkit.safeAsyncExec((Widget)viewer, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        viewer.refresh();
                    }
                });
            }
        });
    }

    private void addDials(DialViewer dialViewer, DialInformationViewer dialInformationViewer) {
        DialDescriptorRepository repository = this.getRepository();
        List<DialDescriptor> dials = repository.getDialDescriptors();
        IDialInformationProvider[] infoProviders = new IDialInformationProvider[dials.size()];
        IDialProvider[] dialProviders = new IDialProvider[dials.size()];
        int n = 0;
        while (n < dials.size()) {
            DialDescriptor dd = dials.get(n);
            String dialID = Integer.toString(n);
            dialProviders[n] = dials.get(n).getAnimated() ? new MovingDial(dialID, dd.getColor()) : new FixedDial(dialID, dd.getColor());
            infoProviders[n] = new DialInformationProvider(dialID, repository.getUnit().getUnit(), dd.getName());
            ++n;
        }
        dialViewer.setProviders(dialProviders);
        dialInformationViewer.setProviders(infoProviders);
    }

    public String getTitle() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    @Override
    public void operativeSetChange() {
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getRepository().getEventTypeDescriptorBase();
    }
}

