/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.prism.Image;
import com.sun.prism.impl.PrismSettings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import sun.util.logging.PlatformLogger;

class PrismImageLoader2
implements ImageLoader {
    private static PlatformLogger imageioLogger = null;
    private Image[] images;
    private int[] delayTimes;
    private int width;
    private int height;
    private float pixelScale;
    private Exception exception;

    public PrismImageLoader2(String string, int n, int n2, boolean bl, float f, boolean bl2) {
        this.loadAll(string, n, n2, bl, f, bl2);
    }

    public PrismImageLoader2(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        this.loadAll(inputStream, n, n2, bl, bl2);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getFrameCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.length;
    }

    @Override
    public PlatformImage getFrame(int n) {
        if (this.images == null) {
            return null;
        }
        return this.images[n];
    }

    @Override
    public int getFrameDelay(int n) {
        if (this.images == null) {
            return 0;
        }
        return this.delayTimes[n];
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    private void loadAll(String string, int n, int n2, boolean bl, float f, boolean bl2) {
        PrismLoadListener prismLoadListener = new PrismLoadListener();
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(string, (ImageLoadListener)prismLoadListener, n, n2, bl, f, bl2);
            this.convertAll(imageFrameArray);
        }
        catch (ImageStorageException imageStorageException) {
            this.handleException(imageStorageException);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void loadAll(InputStream inputStream, int n, int n2, boolean bl, boolean bl2) {
        PrismLoadListener prismLoadListener = new PrismLoadListener();
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(inputStream, (ImageLoadListener)prismLoadListener, n, n2, bl, 1.0f, bl2);
            this.convertAll(imageFrameArray);
        }
        catch (ImageStorageException imageStorageException) {
            this.handleException(imageStorageException);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    private void handleException(ImageStorageException imageStorageException) {
        Throwable throwable = imageStorageException.getCause();
        if (throwable instanceof Exception) {
            this.handleException((Exception)throwable);
        } else {
            this.handleException((Exception)imageStorageException);
        }
    }

    private void handleException(Exception exception) {
        if (PrismSettings.verbose) {
            exception.printStackTrace(System.err);
        }
        this.exception = exception;
    }

    private void convertAll(ImageFrame[] imageFrameArray) {
        int n = imageFrameArray.length;
        this.images = new Image[n];
        this.delayTimes = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2;
            ImageFrame imageFrame = imageFrameArray[i];
            this.images[i] = Image.convertImageFrame(imageFrame);
            ImageMetadata imageMetadata = imageFrame.getMetadata();
            if (imageMetadata != null && (n2 = imageMetadata.delayTime) != null) {
                this.delayTimes[i] = n2;
            }
            if (i != 0) continue;
            this.width = imageFrame.getWidth();
            this.height = imageFrame.getHeight();
        }
    }

    private static synchronized PlatformLogger getImageioLogger() {
        if (imageioLogger == null) {
            imageioLogger = PlatformLogger.getLogger("imageio");
        }
        return imageioLogger;
    }

    static final class AsyncImageLoader
    extends AbstractRemoteResource<PrismImageLoader2> {
        private static final ExecutorService BG_LOADING_EXECUTOR = AsyncImageLoader.createExecutor();
        private final AccessControlContext acc;
        int width;
        int height;
        boolean preserveRatio;
        boolean smooth;

        public AsyncImageLoader(AsyncOperationListener<PrismImageLoader2> asyncOperationListener, String string, int n, int n2, boolean bl, boolean bl2) {
            super(string, asyncOperationListener);
            this.width = n;
            this.height = n2;
            this.preserveRatio = bl;
            this.smooth = bl2;
            this.acc = AccessController.getContext();
        }

        @Override
        protected PrismImageLoader2 processStream(InputStream inputStream) throws IOException {
            return new PrismImageLoader2(inputStream, this.width, this.height, this.preserveRatio, this.smooth);
        }

        @Override
        public PrismImageLoader2 call() throws IOException {
            try {
                return AccessController.doPrivileged(() -> (PrismImageLoader2)AsyncImageLoader.super.call(), this.acc);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new UndeclaredThrowableException(throwable);
            }
        }

        @Override
        public void start() {
            BG_LOADING_EXECUTOR.execute(this.future);
        }

        private static ExecutorService createExecutor() {
            ThreadGroup threadGroup = AccessController.doPrivileged(() -> new ThreadGroup(QuantumToolkit.getFxUserThread().getThreadGroup(), "Background image loading thread pool"));
            ThreadFactory threadFactory = runnable -> AccessController.doPrivileged(() -> {
                Thread thread = new Thread(threadGroup, runnable);
                thread.setPriority(1);
                return thread;
            });
            ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
            ((ThreadPoolExecutor)executorService).setKeepAliveTime(1L, TimeUnit.SECONDS);
            return executorService;
        }
    }

    private class PrismLoadListener
    implements ImageLoadListener {
        private PrismLoadListener() {
        }

        @Override
        public void imageLoadWarning(com.sun.javafx.iio.ImageLoader imageLoader, String string) {
            PrismImageLoader2.getImageioLogger().warning(string);
        }

        @Override
        public void imageLoadProgress(com.sun.javafx.iio.ImageLoader imageLoader, float f) {
        }

        @Override
        public void imageLoadMetaData(com.sun.javafx.iio.ImageLoader imageLoader, ImageMetadata imageMetadata) {
        }
    }
}

