/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.tab;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationRegistry;
import com.jrockit.mc.ui.checkedstate.ICheckedStateModifierProvider;
import java.util.Collection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

public class RuleCheckedStateProvider
implements ICheckedStateModifierProvider {
    private final IMRIService mriService;
    private final String serverGuid;

    public RuleCheckedStateProvider(IMRIService mriService, String serverGuid) {
        this.mriService = mriService;
        this.serverGuid = serverGuid;
    }

    public Boolean isChecked(Object element) {
        if (element instanceof TriggerRule) {
            Collection list = this.getNotificationRepository().getRegisteredRules(this.serverGuid);
            return list.contains(element);
        }
        return null;
    }

    public Boolean isGreyed(Object element) {
        if (element instanceof TriggerRule) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean setChecked(Object element, boolean checked) {
        if (element instanceof TriggerRule) {
            TriggerRule rule = (TriggerRule)element;
            if (!checked) {
                this.unregisterRule(rule);
            } else if (this.canRegister(rule)) {
                if (!this.registerRule(rule)) {
                    this.unregisterRule(rule);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    boolean canRegister(TriggerRule rule) {
        return rule.isReady() && this.mriService != null && this.mriService.isAttributeAvailable(rule.getTrigger().getAttributeDescriptor());
    }

    public boolean setGreyed(Object element, boolean greyed) {
        return element instanceof TriggerRule;
    }

    private void unregisterRule(TriggerRule rule) {
        this.getNotificationRepository().unregisterRule(rule, this.serverGuid);
    }

    private boolean registerRule(TriggerRule rule) {
        return this.getNotificationRepository().registerRule(rule, this.serverGuid);
    }

    private NotificationRegistry getNotificationRepository() {
        return (NotificationRegistry)RJMXPlugin.getDefault().getService(NotificationRegistry.class);
    }

    public void checkStateChanged(CheckboxTreeViewer viewer) {
    }
}

