/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.arm;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaCallWrapper;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.arm.ARMJavaCallWrapper;
import sun.jvm.hotspot.runtime.arm.ARMRegisterMap;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class ARMFrame
extends Frame {
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.arm.ARMFrame.DEBUG") != null;
    private static final int LINK_OFFSET = 0;
    private static final int RETURN_ADDR_OFFSET = 1;
    private static final int SENDER_SP_OFFSET = 2;
    private static final int INTERPRETER_FRAME_MIRROR_OFFSET = 2;
    private static final int INTERPRETER_FRAME_SENDER_SP_OFFSET = -1;
    private static final int INTERPRETER_FRAME_LAST_SP_OFFSET = -2;
    private static final int INTERPRETER_FRAME_METHOD_OFFSET = -3;
    private static int INTERPRETER_FRAME_MDX_OFFSET;
    private static int INTERPRETER_FRAME_CACHE_OFFSET;
    private static int INTERPRETER_FRAME_LOCALS_OFFSET;
    private static int INTERPRETER_FRAME_BCX_OFFSET;
    private static int INTERPRETER_FRAME_INITIAL_SP_OFFSET;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET;
    private static int INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET;
    private static final int ENTRY_FRAME_CALL_WRAPPER_OFFSET = 0;
    private static final int NATIVE_FRAME_INITIAL_PARAM_OFFSET = 2;
    Address raw_fp;
    private Address raw_unextendedSP;

    private static synchronized void initialize(TypeDataBase db) {
        if (VM.getVM().isCore()) {
            INTERPRETER_FRAME_CACHE_OFFSET = -4;
        } else {
            INTERPRETER_FRAME_MDX_OFFSET = -4;
            INTERPRETER_FRAME_CACHE_OFFSET = INTERPRETER_FRAME_MDX_OFFSET - 1;
        }
        INTERPRETER_FRAME_LOCALS_OFFSET = INTERPRETER_FRAME_CACHE_OFFSET - 1;
        INTERPRETER_FRAME_BCX_OFFSET = INTERPRETER_FRAME_LOCALS_OFFSET - 1;
        INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET = INTERPRETER_FRAME_INITIAL_SP_OFFSET = INTERPRETER_FRAME_BCX_OFFSET - 1;
        INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET = INTERPRETER_FRAME_INITIAL_SP_OFFSET;
    }

    private ARMFrame() {
    }

    private void adjustUnextendedSP() {
        NMethod senderNm;
        CodeBlob cb = this.cb();
        NMethod nMethod = senderNm = cb == null ? null : cb.asNMethodOrNull();
        if (senderNm != null) {
            if (senderNm.isDeoptMhEntry(this.getPC())) {
                this.raw_unextendedSP = this.raw_fp;
            } else if (!senderNm.isDeoptEntry(this.getPC()) && senderNm.isMethodHandleReturn(this.getPC())) {
                this.raw_unextendedSP = this.raw_fp;
            }
        }
    }

    private void adjustForDeopt() {
        NMethod nm;
        CodeBlob cb;
        if (this.pc != null && (cb = VM.getVM().getCodeCache().findBlob(this.pc)) != null && cb.isJavaMethod() && this.pc.equals((nm = (NMethod)cb).deoptHandlerBegin())) {
            if (Assert.ASSERTS_ENABLED) {
                Assert.that(this.getUnextendedSP() != null, "null SP in Java frame");
            }
            this.pc = this.getUnextendedSP().getAddressAt(nm.origPCOffset());
            this.deoptimized = true;
        }
    }

    public ARMFrame(Address raw_sp, Address raw_fp, Address pc) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = pc;
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("ARMFrame(sp, fp, pc): " + this);
            this.dumpStack();
        }
    }

    public ARMFrame(Address raw_sp, Address raw_fp) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = raw_sp;
        this.raw_fp = raw_fp;
        this.pc = raw_sp.getAddressAt(-1L * VM.getVM().getAddressSize());
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("ARMFrame(sp, fp): " + this);
            this.dumpStack();
        }
    }

    public ARMFrame(Address raw_sp, Address raw_fp, Address pc, Address unextended_sp) {
        this.raw_sp = raw_sp;
        this.raw_unextendedSP = unextended_sp;
        this.raw_fp = raw_fp;
        this.pc = pc;
        this.adjustUnextendedSP();
        this.adjustForDeopt();
        if (DEBUG) {
            System.out.println("ARMFrame(sp, fp): " + this);
            this.dumpStack();
        }
    }

    @Override
    public Object clone() {
        ARMFrame frame = new ARMFrame();
        frame.raw_sp = this.raw_sp;
        frame.raw_unextendedSP = this.raw_unextendedSP;
        frame.raw_fp = this.raw_fp;
        frame.pc = this.pc;
        frame.deoptimized = this.deoptimized;
        return frame;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof ARMFrame)) {
            return false;
        }
        ARMFrame other = (ARMFrame)arg;
        return AddressOps.equal(this.getSP(), other.getSP()) && AddressOps.equal(this.getUnextendedSP(), other.getUnextendedSP()) && AddressOps.equal(this.getFP(), other.getFP()) && AddressOps.equal(this.getPC(), other.getPC());
    }

    public int hashCode() {
        if (this.raw_sp == null) {
            return 0;
        }
        return this.raw_sp.hashCode();
    }

    public String toString() {
        return "sp: " + (this.getSP() == null ? "null" : this.getSP().toString()) + ", unextendedSP: " + (this.getUnextendedSP() == null ? "null" : this.getUnextendedSP().toString()) + ", fp: " + (this.getFP() == null ? "null" : this.getFP().toString()) + ", pc: " + (this.pc == null ? "null" : this.pc.toString());
    }

    @Override
    public Address getFP() {
        return this.raw_fp;
    }

    @Override
    public Address getSP() {
        return this.raw_sp;
    }

    @Override
    public Address getID() {
        return this.raw_sp;
    }

    @Override
    public boolean isSignalHandlerFrameDbg() {
        return false;
    }

    @Override
    public int getSignalNumberDbg() {
        return 0;
    }

    @Override
    public String getSignalNameDbg() {
        return null;
    }

    @Override
    public boolean isInterpretedFrameValid() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "Not an interpreted frame");
        }
        if (this.getFP() == null || this.getFP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getSP() == null || this.getSP().andWithMask(3L) != null) {
            return false;
        }
        if (this.getFP().addOffsetTo((long)INTERPRETER_FRAME_INITIAL_SP_OFFSET * VM.getVM().getAddressSize()).lessThan(this.getSP())) {
            return false;
        }
        if (this.getFP().lessThanOrEqual(this.getSP())) {
            return false;
        }
        return this.getFP().minus(this.getSP()) <= 4096L * VM.getVM().getAddressSize();
    }

    @Override
    public Frame sender(RegisterMap regMap, CodeBlob cb) {
        ARMRegisterMap map = (ARMRegisterMap)regMap;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        map.setIncludeArgumentOops(false);
        if (this.isEntryFrame()) {
            return this.senderForEntryFrame(map);
        }
        if (this.isInterpretedFrame()) {
            return this.senderForInterpreterFrame(map);
        }
        if (!VM.getVM().isCore()) {
            if (cb == null) {
                cb = VM.getVM().getCodeCache().findBlob(this.getPC());
            } else if (Assert.ASSERTS_ENABLED) {
                Assert.that(cb.equals(VM.getVM().getCodeCache().findBlob(this.getPC())), "Must be the same");
            }
            if (cb != null) {
                return this.senderForCompiledFrame(map, cb);
            }
        }
        return new ARMFrame(this.getSenderSP(), this.getLink(), this.getSenderPC());
    }

    private Frame senderForEntryFrame(ARMRegisterMap map) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        ARMJavaCallWrapper jcw = (ARMJavaCallWrapper)this.getEntryFrameCallWrapper();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!this.entryFrameIsFirst(), "next Java fp must be non zero");
            Assert.that(jcw.getLastJavaSP().greaterThan(this.getSP()), "must be above this frame on stack");
        }
        ARMFrame fr = jcw.getLastJavaPC() != null ? new ARMFrame(jcw.getLastJavaSP(), jcw.getLastJavaFP(), jcw.getLastJavaPC()) : new ARMFrame(jcw.getLastJavaSP(), jcw.getLastJavaFP());
        map.clear();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map.getIncludeArgumentOops(), "should be set by clear");
        }
        return fr;
    }

    private Frame senderForInterpreterFrame(ARMRegisterMap map) {
        Address unextendedSP = this.addressOfStackSlot(-1).getAddressAt(0L);
        Address sp = this.addressOfStackSlot(2);
        return new ARMFrame(sp, this.getLink(), this.getSenderPC(), unextendedSP);
    }

    private Frame senderForCompiledFrame(ARMRegisterMap map, CodeBlob cb) {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(map != null, "map must be set");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(cb.getFrameSize() >= 0L, "Compiled by Compiler1: do not use");
        }
        Address sender_sp = this.getUnextendedSP().addOffsetTo(cb.getFrameSize());
        Address sender_pc = sender_sp.getAddressAt(-1L * VM.getVM().getAddressSize());
        if (map.getUpdateMap() && cb.getOopMaps() != null) {
            OopMapSet.updateRegisterMap(this, cb, map, true);
        }
        map.setIncludeArgumentOops(cb.callerMustGCArguments());
        Address saved_fp = null;
        saved_fp = sender_sp.getAddressAt(-2L * VM.getVM().getAddressSize());
        return new ARMFrame(sender_sp, saved_fp, sender_pc);
    }

    @Override
    protected boolean hasSenderPD() {
        return true;
    }

    @Override
    public long frameSize() {
        return this.getSenderSP().minus(this.getSP()) / VM.getVM().getAddressSize();
    }

    @Override
    public Address getLink() {
        return this.addressOfStackSlot(0).getAddressAt(0L);
    }

    @Override
    public Address getUnextendedSP() {
        return this.raw_unextendedSP;
    }

    public Address getSenderPCAddr() {
        return this.addressOfStackSlot(1);
    }

    @Override
    public Address getSenderPC() {
        return this.getSenderPCAddr().getAddressAt(0L);
    }

    public Address getNativeParamAddr(int idx) {
        return this.addressOfStackSlot(2 + idx);
    }

    @Override
    public Address getSenderSP() {
        return this.addressOfStackSlot(2);
    }

    @Override
    public Address addressOfInterpreterFrameLocals() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_LOCALS_OFFSET);
    }

    private Address addressOfInterpreterFrameBCX() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_BCX_OFFSET);
    }

    @Override
    public int getInterpreterFrameBCI() {
        Address bcp = this.addressOfInterpreterFrameBCX().getAddressAt(0L);
        Address methodHandle = this.addressOfInterpreterFrameMethod().getAddressAt(0L);
        Method method = (Method)Metadata.instantiateWrapperFor(methodHandle);
        return this.bcpToBci(bcp, method);
    }

    public Address addressOfInterpreterFrameMDX() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_MDX_OFFSET);
    }

    @Override
    public Address addressOfInterpreterFrameExpressionStack() {
        Address monitorEnd = this.interpreterFrameMonitorEnd().address();
        return monitorEnd.addOffsetTo(-1L * VM.getVM().getAddressSize());
    }

    @Override
    public int getInterpreterFrameExpressionStackDirection() {
        return -1;
    }

    @Override
    public Address addressOfInterpreterFrameTOS() {
        return this.getSP();
    }

    @Override
    public Address addressOfInterpreterFrameTOSAt(int slot) {
        return this.addressOfInterpreterFrameTOS().addOffsetTo((long)slot * VM.getVM().getAddressSize());
    }

    @Override
    public Address getInterpreterFrameSenderSP() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.isInterpretedFrame(), "interpreted frame expected");
        }
        return this.addressOfStackSlot(-1).getAddressAt(0L);
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorBegin() {
        return new BasicObjectLock(this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_BOTTOM_OFFSET));
    }

    @Override
    public BasicObjectLock interpreterFrameMonitorEnd() {
        Address result = this.addressOfStackSlot(INTERPRETER_FRAME_MONITOR_BLOCK_TOP_OFFSET).getAddressAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(AddressOps.gt(this.getFP(), result), "result must <  than frame pointer");
            Assert.that(AddressOps.lte(this.getSP(), result), "result must >= than stack pointer");
        }
        return new BasicObjectLock(result);
    }

    @Override
    public int interpreterFrameMonitorSize() {
        return BasicObjectLock.size();
    }

    @Override
    public Address addressOfInterpreterFrameMethod() {
        return this.addressOfStackSlot(-3);
    }

    @Override
    public Address addressOfInterpreterFrameCPCache() {
        return this.addressOfStackSlot(INTERPRETER_FRAME_CACHE_OFFSET);
    }

    @Override
    public JavaCallWrapper getEntryFrameCallWrapper() {
        return new ARMJavaCallWrapper(this.addressOfStackSlot(0).getAddressAt(0L));
    }

    @Override
    protected Address addressOfSavedOopResult() {
        return this.getSP().addOffsetTo((long)(VM.getVM().isClientCompiler() ? 2 : 3) * VM.getVM().getAddressSize());
    }

    @Override
    protected Address addressOfSavedReceiver() {
        return this.getSP().addOffsetTo(-4L * VM.getVM().getAddressSize());
    }

    private void dumpStack() {
        CodeBlob cb = this.cb();
        if (cb != null) {
            cb.print();
        }
        if (this.getFP() != null) {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getFP().addOffsetTo(5L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        } else {
            Address addr = this.getSP().addOffsetTo(-5L * VM.getVM().getAddressSize());
            while (AddressOps.lte(addr, this.getSP().addOffsetTo(20L * VM.getVM().getAddressSize()))) {
                System.out.println(addr + ": " + addr.getAddressAt(0L));
                addr = addr.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ARMFrame.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

