/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.proc.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.proc.ProcDebugger;
import sun.jvm.hotspot.debugger.proc.arm.ProcARMThreadContext;
import sun.jvm.hotspot.utilities.Assert;

public class ProcARMThread
implements ThreadProxy {
    private ProcDebugger debugger;
    private int id;

    public ProcARMThread(ProcDebugger debugger, Address addr) {
        this.debugger = debugger;
        this.id = (int)addr.getCIntegerAt(0L, 4L, true);
    }

    public ProcARMThread(ProcDebugger debugger, long id) {
        this.debugger = debugger;
        this.id = (int)id;
    }

    @Override
    public ThreadContext getContext() throws IllegalThreadStateException {
        ProcARMThreadContext context = new ProcARMThreadContext(this.debugger);
        long[] regs = this.debugger.getThreadIntegerRegisterSet(this.id);
        if (Assert.ASSERTS_ENABLED) {
            int numRegisters = context.getNumRegisters();
            Assert.that(regs.length <= numRegisters, "size of register set is greater than " + numRegisters);
        }
        for (int i = 0; i < regs.length; ++i) {
            context.setRegister(i, regs[i]);
        }
        return context;
    }

    @Override
    public boolean canSetContext() throws DebuggerException {
        return false;
    }

    @Override
    public void setContext(ThreadContext context) throws IllegalThreadStateException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    public String toString() {
        return "t@" + this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProcARMThread)) {
            return false;
        }
        return ((ProcARMThread)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }
}

