/*
 * Decompiled with CFR 0.152.
 */
package oracle.jvm.hotspot.jfr;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public final class Producer
extends VMObject {
    private static AddressField nextField;
    private static Field descField;
    private static CIntegerField idField;
    private static CIntegerField eventsField;
    private static CIntegerField lenField;

    public Producer(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JfrProducers::Producer");
        descField = type.getField("desc[1]");
        nextField = type.getAddressField("next");
        idField = type.getCIntegerField("id");
        eventsField = type.getCIntegerField("events");
        lenField = type.getCIntegerField("len");
    }

    public Address getNext() {
        return nextField.getValue(this.addr);
    }

    public long getLen() {
        return lenField.getValue(this.addr);
    }

    public byte[] getDescValue() {
        Address descAddress = this.addr.addOffsetTo(descField.getOffset() - 1L);
        int len = (int)this.getLen();
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = descAddress.getJByteAt(i);
        }
        return array;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Producer.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

