/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.internal.platform.CgroupInfo;
import jdk.internal.platform.CgroupMetrics;
import jdk.internal.platform.CgroupSubsystem;
import jdk.internal.platform.CgroupUtil;
import jdk.internal.platform.CgroupV1MetricsImpl;
import jdk.internal.platform.cgroupv1.CgroupV1Subsystem;
import jdk.internal.platform.cgroupv2.CgroupV2Subsystem;

public class CgroupSubsystemFactory {
    private static final String CPU_CTRL = "cpu";
    private static final String CPUACCT_CTRL = "cpuacct";
    private static final String CPUSET_CTRL = "cpuset";
    private static final String BLKIO_CTRL = "blkio";
    private static final String MEMORY_CTRL = "memory";
    private static final Pattern MOUNTINFO_PATTERN = Pattern.compile("^[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+[^\\s]+\\s+([^\\s]+)\\s+[^-]+-\\s+([^\\s]+)\\s+.*$");

    static CgroupMetrics create() {
        Optional<CgroupTypeResult> optional = null;
        try {
            optional = CgroupSubsystemFactory.determineType("/proc/self/mountinfo", "/proc/cgroups");
        }
        catch (IOException iOException) {
            return null;
        }
        if (!optional.isPresent()) {
            return null;
        }
        CgroupTypeResult cgroupTypeResult = optional.get();
        if (!cgroupTypeResult.isAnyControllersEnabled()) {
            return null;
        }
        if (cgroupTypeResult.isAnyCgroupV1Controllers() && cgroupTypeResult.isAnyCgroupV2Controllers()) {
            Logger logger = Logger.getLogger("jdk.internal.platform");
            logger.log(Level.WARNING, "Mixed cgroupv1 and cgroupv2 not supported. Metrics disabled.");
            return null;
        }
        if (cgroupTypeResult.isCgroupV2()) {
            CgroupSubsystem cgroupSubsystem = CgroupV2Subsystem.getInstance();
            return cgroupSubsystem != null ? new CgroupMetrics(cgroupSubsystem) : null;
        }
        CgroupV1Subsystem cgroupV1Subsystem = CgroupV1Subsystem.getInstance();
        return cgroupV1Subsystem != null ? new CgroupV1MetricsImpl(cgroupV1Subsystem) : null;
    }

    public static Optional<CgroupTypeResult> determineType(String string, String string2) throws IOException {
        Object object2;
        HashMap<String, CgroupInfo> hashMap = new HashMap<String, CgroupInfo>();
        List<String> list = CgroupUtil.readAllLinesPrivileged(Paths.get(string2, new String[0]));
        for (String string3 : list) {
            if (string3.startsWith("#")) continue;
            CgroupInfo cgroupInfo = CgroupInfo.fromCgroupsLine(string3);
            switch (cgroupInfo.getName()) {
                case "cpu": {
                    hashMap.put(CPU_CTRL, cgroupInfo);
                    break;
                }
                case "cpuacct": {
                    hashMap.put(CPUACCT_CTRL, cgroupInfo);
                    break;
                }
                case "cpuset": {
                    hashMap.put(CPUSET_CTRL, cgroupInfo);
                    break;
                }
                case "memory": {
                    hashMap.put(MEMORY_CTRL, cgroupInfo);
                    break;
                }
                case "blkio": {
                    hashMap.put(BLKIO_CTRL, cgroupInfo);
                }
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (Object object2 : hashMap.values()) {
            bl4 = bl4 || ((CgroupInfo)object2).getHierarchyId() != 0;
            bl3 = bl3 || ((CgroupInfo)object2).getHierarchyId() == 0;
            bl = bl && ((CgroupInfo)object2).getHierarchyId() == 0;
            bl2 = bl2 || ((CgroupInfo)object2).isEnabled();
        }
        Object object3 = CgroupUtil.readFilePrivileged(Paths.get(string, new String[0]));
        object2 = null;
        try {
            boolean bl5 = object3.anyMatch(CgroupSubsystemFactory::isRelevantControllerMount);
            if (!bl5 && bl) {
                Optional<CgroupTypeResult> optional = Optional.empty();
                return optional;
            }
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object3 != null) {
                if (object2 != null) {
                    try {
                        object3.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    object3.close();
                }
            }
        }
        object3 = new CgroupTypeResult(bl, bl2, bl3, bl4);
        return Optional.of(object3);
    }

    private static boolean isRelevantControllerMount(String string) {
        Matcher matcher = MOUNTINFO_PATTERN.matcher(string.trim());
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string3.equals("cgroup")) {
                String string4 = Paths.get(string2, new String[0]).getFileName().toString();
                String[] stringArray = string4.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string5;
                    switch (string5 = stringArray[i]) {
                        case "memory": 
                        case "cpu": 
                        case "cpuset": 
                        case "cpuacct": 
                        case "blkio": {
                            return true;
                        }
                    }
                }
            } else if (string3.equals("cgroup2")) {
                return true;
            }
        }
        return false;
    }

    public static final class CgroupTypeResult {
        private final boolean isCgroupV2;
        private final boolean anyControllersEnabled;
        private final boolean anyCgroupV2Controllers;
        private final boolean anyCgroupV1Controllers;

        private CgroupTypeResult(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.isCgroupV2 = bl;
            this.anyControllersEnabled = bl2;
            this.anyCgroupV1Controllers = bl4;
            this.anyCgroupV2Controllers = bl3;
        }

        public boolean isCgroupV2() {
            return this.isCgroupV2;
        }

        public boolean isAnyControllersEnabled() {
            return this.anyControllersEnabled;
        }

        public boolean isAnyCgroupV2Controllers() {
            return this.anyCgroupV2Controllers;
        }

        public boolean isAnyCgroupV1Controllers() {
            return this.anyCgroupV1Controllers;
        }
    }
}

