/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.regex.Pattern;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public final class PKCS12Attribute
implements KeyStore.Entry.Attribute {
    private static final Pattern COLON_SEPARATED_HEX_PAIRS = Pattern.compile("^[0-9a-fA-F]{2}(:[0-9a-fA-F]{2})+$");
    private String name;
    private String value;
    private byte[] encoded;
    private int hashValue = -1;

    public PKCS12Attribute(String string, String string2) {
        ObjectIdentifier objectIdentifier;
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        try {
            objectIdentifier = ObjectIdentifier.of(string);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: name", iOException);
        }
        this.name = string;
        int n = string2.length();
        String[] stringArray = string2.charAt(0) == '[' && string2.charAt(n - 1) == ']' ? string2.substring(1, n - 1).split(", ") : new String[]{string2};
        this.value = string2;
        try {
            this.encoded = this.encode(objectIdentifier, stringArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: value", iOException);
        }
    }

    public PKCS12Attribute(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.encoded = (byte[])byArray.clone();
        try {
            this.parse(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Incorrect format: encoded", iOException);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public byte[] getEncoded() {
        return (byte[])this.encoded.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS12Attribute)) {
            return false;
        }
        return Arrays.equals(this.encoded, ((PKCS12Attribute)object).getEncoded());
    }

    public int hashCode() {
        if (this.hashValue == -1) {
            Arrays.hashCode(this.encoded);
        }
        return this.hashValue;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }

    private byte[] encode(ObjectIdentifier objectIdentifier, String[] stringArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (String string : stringArray) {
            if (COLON_SEPARATED_HEX_PAIRS.matcher(string).matches()) {
                byte[] byArray = new BigInteger(string.replace(":", ""), 16).toByteArray();
                if (byArray[0] == 0) {
                    byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
                }
                derOutputStream2.putOctetString(byArray);
                continue;
            }
            derOutputStream2.putUTF8String(string);
        }
        derOutputStream.write((byte)49, derOutputStream2);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream);
        return derOutputStream3.toByteArray();
    }

    private void parse(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            throw new IOException("Invalid length for PKCS12Attribute");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[1].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSet(1);
        Object[] objectArray = new String[derValueArray2.length];
        for (int i = 0; i < derValueArray2.length; ++i) {
            String string;
            objectArray[i] = derValueArray2[i].tag == 4 ? Debug.toString(derValueArray2[i].getOctetString()) : ((string = derValueArray2[i].getAsString()) != null ? string : (derValueArray2[i].tag == 6 ? derValueArray2[i].getOID().toString() : (derValueArray2[i].tag == 24 ? derValueArray2[i].getGeneralizedTime().toString() : (derValueArray2[i].tag == 23 ? derValueArray2[i].getUTCTime().toString() : (derValueArray2[i].tag == 2 ? derValueArray2[i].getBigInteger().toString() : (derValueArray2[i].tag == 1 ? String.valueOf(derValueArray2[i].getBoolean()) : Debug.toString(derValueArray2[i].getDataBytes())))))));
        }
        this.name = objectIdentifier.toString();
        this.value = objectArray.length == 1 ? objectArray[0] : Arrays.toString(objectArray);
    }
}

