/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.ECKeyValue;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class ECKeyValueResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(ECKeyValueResolver.class);

    @Override
    protected boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "KeyValue") || XMLUtils.elementIsInSignatureSpace(element, "ECKeyValue");
    }

    @Override
    protected PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        boolean bl2 = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        if (bl2) {
            element2 = XMLUtils.selectDs11Node(element.getFirstChild(), "ECKeyValue", 0);
        } else if (XMLUtils.elementIsInSignature11Space(element, "ECKeyValue")) {
            element2 = element;
        }
        if (element2 == null) {
            return null;
        }
        try {
            ECKeyValue eCKeyValue = new ECKeyValue(element2, string);
            return eCKeyValue.getPublicKey();
        }
        catch (XMLSecurityException xMLSecurityException) {
            LOG.debug(xMLSecurityException.getMessage(), xMLSecurityException);
            return null;
        }
    }

    @Override
    protected X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    @Override
    protected SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }

    @Override
    protected PrivateKey engineResolvePrivateKey(Element element, String string, StorageResolver storageResolver, boolean bl) {
        return null;
    }
}

