/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessData;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SlownessReporter {
    private final Queue<NotifySnapshot> pending = new LinkedList<NotifySnapshot>();
    private static final String UI_ACTION_BUTTON_PRESS = "UI_ACTION_BUTTON_PRESS";
    private static final String UI_ACTION_EDITOR = "UI_ACTION_EDITOR";
    private static final String UI_ACTION_KEY_PRESS = "UI_ACTION_KEY_PRESS";
    private static final String DELEGATE_PATTERN = "delegate=.*@";
    static final long LATEST_ACTION_LIMIT = 1000L;
    private static final int PRIORITY;
    private static final int CLEAR;
    private static final RequestProcessor IO_RP;

    private String getParam(LogRecord logRecord, int n) {
        if (logRecord.getParameters() != null && logRecord.getParameters().length > n) {
            return logRecord.getParameters()[n].toString();
        }
        assert (logRecord.getParameters() != null);
        assert (logRecord.getParameters().length > n) : Integer.toString(logRecord.getParameters().length);
        return null;
    }

    String getLatestAction(final long l, final long l2) {
        final String[] stringArray = new String[1];
        Installer.readLogs(new Handler(){

            @Override
            public void publish(LogRecord logRecord) {
                if (l2 - logRecord.getMillis() - l > 1000L) {
                    return;
                }
                String string = null;
                if ("IDE_STARTUP".equals(logRecord.getMessage())) {
                    string = NbBundle.getMessage(SlownessReporter.class, (String)"IDE_STARTUP");
                } else if (SlownessReporter.UI_ACTION_EDITOR.equals(logRecord.getMessage()) || SlownessReporter.UI_ACTION_BUTTON_PRESS.equals(logRecord.getMessage()) || SlownessReporter.UI_ACTION_KEY_PRESS.equals(logRecord.getMessage())) {
                    string = SlownessReporter.this.getParam(logRecord, 4);
                }
                if (string != null) {
                    string = string.replaceAll("&", "");
                    Pattern pattern = Pattern.compile(SlownessReporter.DELEGATE_PATTERN);
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.find()) {
                        String string2 = matcher.group();
                        string = string2.substring(9, string2.length() - 1);
                    }
                }
                if (string != null) {
                    stringArray[0] = string;
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        return stringArray[0];
    }

    void notifySlowness(final byte[] byArray, final long l, final long l2, final String string) {
        IO_RP.post(new Runnable(){

            @Override
            public void run() {
                final String string2 = SlownessReporter.this.getLatestAction(l, l2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SlownessReporter.this.pending.add(new NotifySnapshot(new SlownessData(l, byArray, string, string2)));
                        if (SlownessReporter.this.pending.size() > 5) {
                            ((NotifySnapshot)SlownessReporter.this.pending.remove()).clear();
                        }
                    }
                });
            }
        });
    }

    static {
        int n = 20000;
        if (!$assertionsDisabled) {
            n = 10000;
            if (10000 <= 0) {
                throw new AssertionError();
            }
        }
        PRIORITY = Integer.getInteger("org.netbeans.modules.uihandler.SlownessReporter.priority", n);
        CLEAR = Integer.getInteger("org.netbeans.modules.uihandler.SlownessReporter.clear", 0);
        IO_RP = new RequestProcessor(SlownessReporter.class);
    }

    private static final class NotifySnapshot
    implements ActionListener,
    Runnable {
        private final Notification note;
        private final SlownessData data;

        NotifySnapshot(SlownessData slownessData) {
            this.data = slownessData;
            NotificationDisplayer.Priority priority = slownessData.getTime() > (long)PRIORITY ? NotificationDisplayer.Priority.LOW : NotificationDisplayer.Priority.SILENT;
            String string = NbBundle.getMessage(NotifySnapshot.class, (String)slownessData.getSlownessType());
            this.note = NotificationDisplayer.getDefault().notify(string, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/uihandler/vilik.png", (boolean)true), this.createPanel(), this.createPanel(), priority, NotificationDisplayer.Category.WARNING);
            if (CLEAR > 0) {
                Installer.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        NotifySnapshot.this.clear();
                    }
                }, CLEAR, 1);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Installer.RP.post((Runnable)this);
        }

        public void clear() {
            this.note.clear();
        }

        private JComponent createPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(new JLabel(NbBundle.getMessage(NotifySnapshot.class, (String)("BlockedFor" + this.data.getSlownessType()), (Object)this.data.getTime(), (Object)(this.data.getTime() / 1000L))));
            jPanel.add(this.createDetails(NbBundle.getMessage(NotifySnapshot.class, (String)"Report")));
            return jPanel;
        }

        private JButton createDetails(String string) {
            HtmlButton htmlButton = new HtmlButton(string);
            htmlButton.setFocusable(false);
            htmlButton.setBorder(BorderFactory.createEmptyBorder());
            htmlButton.setBorderPainted(false);
            htmlButton.setFocusPainted(false);
            htmlButton.setOpaque(false);
            htmlButton.setContentAreaFilled(false);
            htmlButton.addActionListener(this);
            htmlButton.setCursor(Cursor.getPredefinedCursor(12));
            return htmlButton;
        }

        @Override
        public void run() {
            Installer.displaySummary("ERROR_URL", true, false, true, this.data);
        }

        private static class HtmlButton
        extends JButton {
            public HtmlButton(String string) {
                super(string);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                HtmlRenderer.renderString((String)("<html><a>" + this.getText() + "</a></html>"), (Graphics)graphics, (int)0, (int)this.getBaseline(Integer.MAX_VALUE, this.getFont().getSize()), (int)Integer.MAX_VALUE, (int)this.getFont().getSize(), (Font)this.getFont(), (Color)this.getForeground(), (int)0, (boolean)true);
            }
        }
    }
}

