/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.storage.implementations;

import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolverSpi;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class KeyStoreResolver
extends StorageResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreResolver.class);
    private final KeyStore keyStore;

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this.keyStore = keyStore;
        try {
            keyStore.aliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new StorageResolverException(keyStoreException);
        }
    }

    @Override
    public Iterator<Certificate> getIterator() {
        return new KeyStoreIterator(this.keyStore);
    }

    static class KeyStoreIterator
    implements Iterator<Certificate> {
        private final List<Certificate> certs;
        private int i;

        public KeyStoreIterator(KeyStore keyStore) {
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            try {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    Certificate certificate = keyStore.getCertificate(string);
                    if (certificate == null) continue;
                    arrayList.add(certificate);
                }
            }
            catch (KeyStoreException keyStoreException) {
                LOG.debug("Error reading certificates: {}", keyStoreException.getMessage());
            }
            this.certs = Collections.unmodifiableList(arrayList);
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.certs.size();
        }

        @Override
        public Certificate next() {
            if (this.hasNext()) {
                return this.certs.get(this.i++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

