/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.internal.services.ResourceBundleTranslationProvider;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.nls.IMessageFactoryService;
import org.eclipse.e4.core.services.nls.Message;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.log.LogService;

public class MessageFactoryServiceImpl
implements IMessageFactoryService {
    private static LogService logService = ServicesActivator.getDefault().getLogService();
    private Map<Object, Reference<Object>> SOFT_CACHE = Collections.synchronizedMap(new HashMap());
    private Map<Object, Reference<Object>> WEAK_CACHE = Collections.synchronizedMap(new HashMap());
    private int CLEANUPCOUNT = 0;

    @Override
    public <M> M getMessageInstance(final Locale locale, final Class<M> messages, final ResourceBundleProvider provider) {
        String key = String.valueOf(messages.getName()) + "_" + locale;
        final Message annotation = messages.getAnnotation(Message.class);
        Map<Object, Reference<Object>> cache = null;
        Message.ReferenceType type = Message.ReferenceType.NONE;
        if (++this.CLEANUPCOUNT > 1000) {
            Iterator<Map.Entry<Object, Reference<Object>>> it = this.WEAK_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            it = this.SOFT_CACHE.entrySet().iterator();
            while (it.hasNext()) {
                if (it.next().getValue().get() != null) continue;
                it.remove();
            }
            this.CLEANUPCOUNT = 0;
        }
        if (annotation == null || annotation.referenceType() == Message.ReferenceType.SOFT) {
            cache = this.SOFT_CACHE;
            type = Message.ReferenceType.SOFT;
        } else if (annotation.referenceType() == Message.ReferenceType.WEAK) {
            cache = this.WEAK_CACHE;
            type = Message.ReferenceType.WEAK;
        }
        if (cache != null && cache.containsKey(key)) {
            Reference<Object> ref = cache.get(key);
            Object o = ref.get();
            if (o != null) {
                return (M)o;
            }
            cache.remove(key);
        }
        Object instance = System.getSecurityManager() == null ? MessageFactoryServiceImpl.createInstance(locale, messages, annotation, provider) : AccessController.doPrivileged(new PrivilegedAction<M>(){

            @Override
            public M run() {
                return MessageFactoryServiceImpl.createInstance(locale, messages, annotation, provider);
            }
        });
        if (cache != null) {
            if (type == Message.ReferenceType.SOFT) {
                cache.put(key, new SoftReference<M>(instance));
            } else if (type == Message.ReferenceType.WEAK) {
                cache.put(key, new WeakReference<M>(instance));
            }
        }
        return instance;
    }

    private static <M> M createInstance(Locale locale, Class<M> messages, Message annotation, ResourceBundleProvider rbProvider) {
        M instance;
        block13: {
            String baseName;
            ResourceBundle resourceBundle = null;
            if (annotation != null) {
                if (annotation.contributionURI().length() > 0) {
                    resourceBundle = ResourceBundleHelper.getResourceBundleForUri(annotation.contributionURI(), locale, rbProvider);
                } else if (annotation.contributorURI().length() > 0) {
                    if (logService != null) {
                        logService.log(2, "Usage of @Message#contributorURI detected! Please use @Message#contributionURI instead!");
                    }
                    resourceBundle = ResourceBundleHelper.getResourceBundleForUri(annotation.contributorURI(), locale, rbProvider);
                }
            }
            if (resourceBundle == null && (resourceBundle = ResourceBundleHelper.getEquinoxResourceBundle(baseName = messages.getName().replace('.', '/'), locale, messages.getClassLoader())) == null) {
                resourceBundle = ResourceBundleHelper.getEquinoxResourceBundle(baseName.toLowerCase(), locale, messages.getClassLoader());
            }
            if (resourceBundle == null) {
                Bundle bundle = FrameworkUtil.getBundle(messages);
                resourceBundle = rbProvider.getResourceBundle(bundle, locale.toString());
            }
            ResourceBundleTranslationProvider provider = new ResourceBundleTranslationProvider(resourceBundle);
            instance = null;
            try {
                instance = messages.newInstance();
                Field[] fields = messages.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    if (!fields[i].isAccessible()) {
                        fields[i].setAccessible(true);
                    }
                    fields[i].set(instance, provider.translate(fields[i].getName()));
                    ++i;
                }
            }
            catch (InstantiationException e) {
                if (logService != null) {
                    logService.log(1, "Instantiation of messages class failed", (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (logService == null) break block13;
                logService.log(1, "Failed to access messages class", (Throwable)e);
            }
        }
        MessageFactoryServiceImpl.processPostConstruct(instance, messages);
        return instance;
    }

    private static void processPostConstruct(Object messageObject, Class<?> messageClass) {
        if (messageObject != null) {
            Method[] methods = messageClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                block5: {
                    Method method = methods[i];
                    if (method.isAnnotationPresent(PostConstruct.class)) {
                        try {
                            method.invoke(messageObject, new Object[0]);
                        }
                        catch (Exception e) {
                            if (logService == null) break block5;
                            logService.log(1, "Exception on trying to execute the @PostConstruct annotated method in " + messageClass, (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

