/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnViewerComponent;
import com.jrockit.mc.flightrecorder.ui.components.fields.EventFieldToolkit;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.successors.IFrameConsumer;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.CollapseAction;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.ExpandAction;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameEqualityChecker;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.FrameNode;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TraceModel;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.TreeContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.menus.OperativeSetMenu;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.fields.BoldFieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldBackgroundPainter;
import com.jrockit.mc.ui.fields.FieldTreeViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.MethodField;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TraceTreeComponent
extends ColumnViewerComponent
implements ITypeVisibilityChange,
INavigatorSelectionChangeListener,
IEventConsumer,
ITypeVisibilitySupport {
    public static final String TREE_EXPANSION_LEVEL = "treeExpansionLevel";
    private final AtomicBoolean considerLineNumber = new AtomicBoolean(false);
    private final AtomicBoolean considerFrameType = new AtomicBoolean(false);
    private final AtomicBoolean considerBci = new AtomicBoolean(false);

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = this.getFormToolkit().createTree(parent, 268501762);
        FieldTreeViewer viewer = new FieldTreeViewer(tree, this.getFields());
        viewer.getTree().setHeaderVisible(true);
        viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new BoldFieldLabelProvider(this.getFields()));
        viewer.setInput(this.getModelBuilder());
        this.hookModelView((ContentViewer)viewer, this.getModelBuilder());
        this.hookSelectionListener(viewer);
        this.getMenuManager().add((IAction)new ExpandAction(viewer));
        this.getMenuManager().add((IAction)new CollapseAction(viewer));
        MenuManager aggregationOptions = new MenuManager(Messages.TRACE_COMPONENT_AGGREGATION_MENU_TEXT);
        aggregationOptions.add((IAction)new AggregationOptionAction(Messages.TRACE_COMPONENT_AGGREGATION_LINE_NUMBER, "line_number_visible", this.considerLineNumber));
        aggregationOptions.add((IAction)new AggregationOptionAction(Messages.TRACE_COMPONENT_AGGREGATION_FRAME_TYPE, "frame_type_visible", this.considerFrameType));
        aggregationOptions.add((IAction)new AggregationOptionAction(Messages.TRACE_COMPONENT_AGGREGATION_BCI, "bci_visible", this.considerBci));
        this.getMenuManager().add((IContributionItem)aggregationOptions);
        if (this.hasBackdropColumn()) {
            this.hookPainter(this.getRepository().getColumnDescriptors(), viewer);
        }
        return viewer;
    }

    private void hookPainter(final List<ColumnDescriptor> columnDescriptors, FieldTreeViewer viewer) {
        viewer.getTree().addListener(40, (Listener)new FieldBackgroundPainter(this.getFields(), 1.0, 2){

            protected void drawFieldBackground(Event event, Object element, Object columnElement, Field field) {
                ColumnDescriptor cd;
                int index = field.INDEX - 1;
                if (index > 0 && (cd = (ColumnDescriptor)columnDescriptors.get(index)).getUseBackdrop() && columnElement instanceof Double) {
                    this.drawColumnPercentage(event, (Double)columnElement, new MCColor(200, 100, 100));
                }
            }
        });
    }

    protected void refreshViewer(ContentViewer viewer) {
        viewer.refresh();
        ((AbstractTreeViewer)viewer).expandToLevel(this.getExpansionLevel());
    }

    private int getExpansionLevel() {
        return (Integer)PersistenceToolkit.getSetting((Object)this.getRepository()).getChildObject(TREE_EXPANSION_LEVEL, Integer.class);
    }

    @Override
    protected final void pushSelection(IStructuredSelection selection) {
        TraceModel model = (TraceModel)this.getModelBuilder().getModel();
        Iterable<IEvent> events = this.createIterable(selection, model);
        ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setSelectedRange(this.getModelBuilder().getView().getRange());
        ((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)).setEventFactory(events);
        if (this.getRepository().getRole() == Role.MASTER) {
            ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
            for (FrameNode node : selection) {
                if (node.getFrame() == null) continue;
                frames.add(node.getFrame());
            }
            for (IFrameConsumer ec : this.getComponents().getComponentsInAncestorScopes(IFrameConsumer.class)) {
                ec.consumeFrame(frames, events);
            }
        }
    }

    private Iterable<IEvent> createIterable(IStructuredSelection selection, TraceModel model) {
        if (!selection.isEmpty()) {
            ArrayList<IMCFrame> frames = new ArrayList<IMCFrame>();
            for (FrameNode node : selection) {
                frames.add(node.getFrame());
            }
            return model.createIterable(frames);
        }
        return new ArrayList<IEvent>();
    }

    private void hookSelectionListener(FieldTreeViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TraceTreeComponent.this.pushSelection((IStructuredSelection)event.getSelection());
            }
        });
    }

    @Override
    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
            this.hookModelBuilder();
            return true;
        }
        return false;
    }

    protected FrameEqualityChecker buildFrameEqualityChecker() {
        return new FrameEqualityChecker(this.considerFrameType.get(), this.considerLineNumber.get(), this.considerBci.get());
    }

    protected ViewModelBuilder<TraceModel> createModelBuilder() {
        return new ViewModelBuilder<TraceModel>(this.getServiceLocator(), this.getComponentDescriptor().getName()){

            @Override
            protected TraceModel buildModel(IView view, IProgressMonitor monitor) {
                TraceModel m = new TraceModel(null, this.getServiceLocator(), TraceTreeComponent.this.getRepository(), view, IMCAggregatedFrame.AggregationType.PREDECESSORS, TraceTreeComponent.this.buildFrameEqualityChecker());
                m.rebuild();
                if (m.isMaxedOut()) {
                    this.setLastBuildMessage(NLS.bind((String)Messages.HISTOGRAM_MODEL_OVERFLOW_TEXT, (Object)this.getComponentName(), (Object)TraceTreeComponent.this.getRepository().getMaximumCount()));
                }
                return m;
            }
        };
    }

    public boolean dispose(IServiceLocator serviceLocator) {
        this.getModelBuilder().stop();
        return super.dispose(serviceLocator);
    }

    protected void hookModelBuilder() {
        this.getModelBuilder().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec((Widget)TraceTreeComponent.this.getViewer().getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TraceTreeComponent.this.getViewer().refresh();
                    }
                });
            }
        });
    }

    @Override
    public HistogramColumnDescriptorRepository getRepository() {
        return (HistogramColumnDescriptorRepository)this.getComponentSettings().getChildObject("columnDescriptorRepository", HistogramColumnDescriptorRepository.class);
    }

    @Override
    public final Field[] createFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        int index = 0;
        fields.add(this.createMethodField(index));
        ++index;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            fields.add(EventFieldToolkit.createField(column, column.getAttributeIdentifier(), index));
            ++index;
        }
        return fields.toArray(new Field[fields.size()]);
    }

    private Field createMethodField(int index) {
        MethodField field = new MethodField(index);
        field.IDENTIFIER = "stackTrace." + index;
        field.setName(Messages.TRACE_COMPONENT_TRACE_COLUMN_TEXT);
        field.setVisible(true);
        field.setMinWidth(300);
        field.setWidthWeight(300);
        field.setModifiable(false);
        field.setSortOrder(true);
        return field;
    }

    @Override
    protected Field findSortedField() {
        int index = 0;
        for (ColumnDescriptor column : this.getRepository().getColumnDescriptors()) {
            assert (index < this.getFields().length);
            if (column.isInitialSortColumn()) {
                return this.getFields()[index + 1];
            }
            ++index;
        }
        return this.getFields()[0];
    }

    public void initalizeUI() {
        this.updateSorting();
        this.getMenuManager().add((IContributionItem)new OperativeSetMenu((OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class)));
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        return this.getRepository().getEventTypeDescriptorRepository();
    }

    class AggregationOptionAction
    extends Action {
        private final AtomicBoolean setting;
        private final String toggleKey;

        AggregationOptionAction(String title, String toggleKey, AtomicBoolean setting) {
            super(title, 2);
            this.toggleKey = toggleKey;
            this.setting = setting;
            boolean defaultValue = setting.get();
            this.setChecked(defaultValue);
            this.updateFields(defaultValue);
        }

        public void run() {
            boolean check = this.isChecked();
            this.setting.set(check);
            this.updateFields(check);
            TraceTreeComponent.this.refresh();
        }

        private void updateFields(boolean checked) {
            Field[] fieldArray = TraceTreeComponent.this.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f instanceof MethodField) {
                    f.setBoolean(this.toggleKey, checked);
                }
                ++n2;
            }
        }
    }
}

