/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.ppc;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.ppc.PPCThreadContext;

public final class LinuxPPCCFrame
extends BasicCFrame {
    private static final int ADDRESS_SIZE = 4;
    private Address pc;
    private Address ebp;
    private LinuxDebugger dbg;

    public LinuxPPCCFrame(LinuxDebugger dbg, Address ebp, Address pc) {
        super(dbg.getCDebugger());
        this.ebp = ebp;
        this.pc = pc;
        this.dbg = dbg;
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.ebp;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        PPCThreadContext context = (PPCThreadContext)thread.getContext();
        Address esp = context.getRegisterAsAddress(1);
        if (this.ebp == null || this.ebp.lessThan(esp)) {
            return null;
        }
        Address nextEBP = this.ebp.getAddressAt(0L);
        if (nextEBP == null) {
            return null;
        }
        Address nextPC = this.ebp.getAddressAt(4L);
        if (nextPC == null) {
            return null;
        }
        return new LinuxPPCCFrame(this.dbg, nextEBP, nextPC);
    }
}

