/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.provider;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class ComponentPanel
extends JPanel {
    private int myWidth;
    private int myHeight;
    private List<JComponent> myComponents;

    ComponentPanel(List<JComponent> list) {
        this.myComponents = this.sort(list);
        this.myHeight = 0;
        this.myWidth = 0;
        for (int i = 0; i < this.myComponents.size(); ++i) {
            JComponent jComponent = this.myComponents.get(i);
            int n = this.getWidth(jComponent);
            int n2 = this.getHeight(jComponent);
            this.myWidth += n;
            if (n2 <= this.myHeight) continue;
            this.myHeight = n2;
        }
    }

    @Override
    public void print(Graphics graphics) {
        for (JComponent jComponent : this.myComponents) {
            jComponent.print(graphics);
            graphics.translate(this.getWidth(jComponent), 0);
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    private int getWidth(JComponent jComponent) {
        Dimension dimension = this.getSize(jComponent);
        if (dimension == null) {
            return jComponent.getWidth();
        }
        return dimension.width;
    }

    private int getHeight(JComponent jComponent) {
        Dimension dimension = this.getSize(jComponent);
        if (dimension == null) {
            return jComponent.getHeight();
        }
        return dimension.height;
    }

    private Dimension getSize(JComponent jComponent) {
        Object object = jComponent.getClientProperty("print.size");
        if (object instanceof Dimension) {
            return (Dimension)object;
        }
        return null;
    }

    private List<JComponent> sort(List<JComponent> list) {
        Collections.sort(list, new Comparator<JComponent>(){

            @Override
            public int compare(JComponent jComponent, JComponent jComponent2) {
                int n;
                int n2 = this.getInteger(jComponent);
                if (n2 < (n = this.getInteger(jComponent2).intValue())) {
                    return -1;
                }
                if (n2 == n) {
                    return 0;
                }
                return 1;
            }

            private Integer getInteger(JComponent jComponent) {
                Object object = jComponent.getClientProperty("print.order");
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                return Integer.MIN_VALUE;
            }
        });
        return list;
    }
}

