/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.actions;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.design.LayoutNotifaction;
import com.jrockit.mc.components.ui.design.LayoutToolkit;
import com.jrockit.mc.components.ui.design.OperationType;
import com.jrockit.mc.components.ui.design.actions.DesignElementAction;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public final class InsertAction
extends DesignElementAction {
    private final POSITION m_position;

    public InsertAction(POSITION position, IDesignElement element) {
        super(position.text, element);
        this.setImageDescriptor(position.imageDescriptor);
        this.m_position = position;
    }

    public void run() {
        LayoutItem child;
        LayoutItem dummy = new LayoutItem();
        LayoutNotifaction notification = null;
        if (this.m_position == POSITION.WEST || this.m_position == POSITION.NORTH || this.m_position == POSITION.BEFORE) {
            child = this.getParentLayoutItem().createBefore(this.getLayoutItem());
            notification = LayoutNotifaction.create(OperationType.INSERT_BEFORE, NLS.bind((String)Messages.DESIGN_MENU_INSERT_BEFORE_NOTIFICATION_DESCRIPTION, (Object)LayoutToolkit.getDisplayName(dummy), (Object)LayoutToolkit.getDisplayName(this.getLayoutItem())), child);
        }
        if (this.m_position == POSITION.EAST || this.m_position == POSITION.SOUTH || this.m_position == POSITION.AFTER) {
            child = this.getParentLayoutItem().createAfter(this.getLayoutItem());
            notification = LayoutNotifaction.create(OperationType.INSERT_BEFORE, NLS.bind((String)Messages.DESIGN_MENU_INSERT_AFTER_NOTIFICATION_DESCRIPTION, (Object)LayoutToolkit.getDisplayName(dummy), (Object)LayoutToolkit.getDisplayName(this.getLayoutItem())), child);
        }
        if (notification != null) {
            this.getParentLayoutItem().notifyObservers(notification);
        }
    }

    public static enum POSITION {
        WEST(Messages.DESIGN_MENU_ADD_LEFT_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("left_arrow.gif")),
        EAST(Messages.DESIGN_MENU_ADD_RIGHT_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("right_arrow.gif")),
        NORTH(Messages.DESIGN_MENU_ADD_ABOVE_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("up_arrow.gif")),
        SOUTH(Messages.DESIGN_MENU_ADD_BELOW_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("down_arrow.gif")),
        BEFORE(Messages.DESIGN_MENU_INSERT_NEW_BEFORE_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("up_arrow.gif")),
        AFTER(Messages.DESIGN_MENU_INSERT_NEW_AFTER_TEXT, ComponentsPlugin.getDefault().getMCImageDescriptor("down_arrow.gif"));

        private final String text;
        private final ImageDescriptor imageDescriptor;

        private POSITION(String text, ImageDescriptor imageDescriptor) {
            this.text = text;
            this.imageDescriptor = imageDescriptor;
        }
    }
}

