/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.column.ColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramItem;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramIteratorFactory;
import com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree.Normalizer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class HistogramModel {
    private final Map<Object, HistogramItem> m_histogram = new LinkedHashMap<Object, HistogramItem>();
    private final HistogramColumnDescriptorRepository m_repository;
    private final IView m_eventView;
    private final GathererFactory m_gatherFactory;
    private final int m_maxItems;
    private HistogramItem m_otherItem;
    private boolean m_maxedOut;
    protected final Normalizer m_normalizer;

    public HistogramModel(HistogramColumnDescriptorRepository repository, IServiceLocator serviceLocator, IView eventView) {
        this.m_eventView = eventView;
        this.m_repository = repository;
        this.m_gatherFactory = new GathererFactory(serviceLocator, repository);
        if (this.m_gatherFactory.needsSortedValues()) {
            this.m_eventView.setOrder(EventOrder.ASCENDING);
        }
        this.m_maxItems = repository.getMaximumCount();
        this.m_normalizer = new Normalizer(repository.getColumnDescriptors().size());
    }

    public void rebuild() {
        this.build();
        this.normalize();
    }

    protected abstract void build();

    protected void normalize() {
        int index = 0;
        for (ColumnDescriptor cd : this.getRepository().getColumnDescriptors()) {
            if (cd.getNormalize()) {
                double total = this.calculateTotalForIndex(index);
                if (total > 0.0 && !Double.isNaN(total)) {
                    this.m_normalizer.setNormalizationFactor(index, total);
                } else {
                    this.zeroOutIndex(index);
                }
            }
            ++index;
        }
    }

    private void zeroOutIndex(int index) {
        for (HistogramItem item : this.getHistogramItems()) {
            Object normalizationValue = item.getValue(index);
            if (!(normalizationValue instanceof Number)) continue;
            item.getValues()[index] = null;
        }
    }

    private double calculateTotalForIndex(int index) {
        double total = 0.0;
        for (HistogramItem item : this.getHistogramItems()) {
            Object normalizationValue;
            if (!item.isUsed() || !((normalizationValue = item.getValue(index)) instanceof Number)) continue;
            total += ((Number)normalizationValue).doubleValue();
        }
        return total;
    }

    protected final ColumnDescriptorRepository getRepository() {
        return this.m_repository;
    }

    protected final IView getEventView() {
        return this.m_eventView;
    }

    public final Iterable<IEvent> createHistogramIteratorFactory(IStructuredSelection selection) {
        return new HistogramIteratorFactory(selection, this.getEventView(), this.m_gatherFactory);
    }

    protected final GathererFactory getGathererFactory() {
        return this.m_gatherFactory;
    }

    protected final HistogramItem getHistogramItem(Object key) {
        HistogramItem histogramItem = this.m_histogram.get(key);
        if (histogramItem == null) {
            if (this.m_histogram.size() - 1 == this.m_maxItems || this.m_histogram.size() == this.m_maxItems) {
                if (this.m_otherItem == null) {
                    this.m_otherItem = HistogramItem.createOther(this.m_gatherFactory.createGather(), this.m_normalizer);
                    this.m_histogram.put(this.m_otherItem.getKey(), this.m_otherItem);
                    this.setMaxedOut(true);
                }
                histogramItem = this.m_otherItem;
            } else {
                histogramItem = new HistogramItem(key, this.m_gatherFactory.createGather(), this.m_normalizer);
                this.m_histogram.put(key, histogramItem);
            }
        }
        return histogramItem;
    }

    private void setMaxedOut(boolean maxedOut) {
        this.m_maxedOut = maxedOut;
    }

    public boolean isMaxedOut() {
        return this.m_maxedOut;
    }

    public final Collection<HistogramItem> getHistogramItems() {
        return this.m_histogram.values();
    }
}

