/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.InterpolatedColorFunction;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UIThreadGroup
implements Visitable {
    private final List<UIThread> m_threads = new ArrayList<UIThread>();
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final HashMap<UITrack, Holder> m_trackHolderMap = new HashMap();
    private final String m_name;

    public UIThreadGroup(String name) {
        this.m_name = name == null ? Messages.TRACK_COMPONENT_UNKNOWN_THREAD_GROUP_TEXT : name;
        this.m_renderInfo.setSampler(new CompositeRangeSampler());
        this.m_renderInfo.setColorFunction(new InterpolatedColorFunction(new MCColor(0, 255, 0), new MCColor(255, 0, 0)));
    }

    public void addTrack(UITrack uiTrack) {
        Holder holder = this.m_trackHolderMap.get(uiTrack);
        if (holder == null) {
            holder = new Holder();
            holder.renderInfo.setSampler(new CompositeRangeSampler());
            holder.renderInfo.setColorFunction(new InterpolatedColorFunction(new MCColor(255, 255, 255), new MCColor(10, 10, 10)));
            this.m_trackHolderMap.put(uiTrack, holder);
        }
        ((CompositeRangeSampler)holder.renderInfo.getSampleComponent()).add(uiTrack.getRenderInfo().getSampleComponent());
        holder.uiTracks.add(uiTrack);
    }

    public List<UIThread> getThreads() {
        return this.m_threads;
    }

    public void addThread(UIThread uiThread) {
        this.m_threads.add(uiThread);
    }

    public String getName() {
        return this.m_name;
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public List<RenderInfo> getRenderInfos() {
        ArrayList<RenderInfo> list = new ArrayList<RenderInfo>(this.m_trackHolderMap.values().size());
        for (Holder holder : this.m_trackHolderMap.values()) {
            list.add(holder.renderInfo);
        }
        return list;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    private static class Holder {
        public final RenderInfo renderInfo = new RenderInfo();
        public final List<UITrack> uiTracks = new ArrayList<UITrack>();

        private Holder() {
        }
    }
}

