/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.aggregators;

import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorType;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;

final class Average
implements IAggregator {
    private double result = 0.0;
    private long count = 0L;

    Average() {
    }

    @Override
    public Object getResult() {
        if (this.count == 0L) {
            return null;
        }
        return this.result / (double)this.count;
    }

    @Override
    public void add(Object value) {
        this.result += ((Number)value).doubleValue();
        ++this.count;
    }

    @Override
    public AggregatorType getCompatibleWith() {
        return AggregatorType.NUMERIC;
    }

    @Override
    public void addFromAggregator(IAggregator gator) {
        this.result += ((Average)gator).result;
        this.count += ((Average)gator).count;
    }
}

