/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider.bcel;

import com.jrockit.mc.flightrecorder.provider.bcel.Arguments;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.util.TimeRangeToolkit;

public final class EventTemplate
implements IEvent {
    final IEventType eventType;
    final long startTime;
    final long endTime;
    private int bitField;

    public EventTemplate(Arguments arguments) {
        this.eventType = arguments.type;
        this.startTime = arguments.startTime;
        this.endTime = arguments.endTime;
    }

    public long getDuration(ITimeRange cropRange) {
        return TimeRangeToolkit.cropRange(cropRange, this);
    }

    @Override
    public IEventType getEventType() {
        return this.eventType;
    }

    @Override
    public int getBitField() {
        return this.bitField;
    }

    @Override
    public void setBitField(int i) {
        this.bitField = i;
    }

    @Override
    public long getDuration() {
        return this.endTime - this.startTime;
    }

    @Override
    public long getEndTimestamp() {
        return this.endTime;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTime;
    }

    @Override
    public Object getValue(String value) {
        IField field = this.eventType.getField(value);
        if (field != null) {
            return field.getValue(this);
        }
        return null;
    }
}

