/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.Widget;

public class TreeGraphLayout<N, E>
extends GraphLayout {
    private GraphScene<N, E> scene;
    private int originX;
    private int originY;
    private int verticalGap;
    private int horizontalGap;
    private boolean vertical;

    public TreeGraphLayout(GraphScene<N, E> graphScene, int n, int n2, int n3, int n4, boolean bl) {
        this.scene = graphScene;
        this.originX = n;
        this.originY = n2;
        this.verticalGap = n3;
        this.horizontalGap = n4;
        this.vertical = bl;
    }

    public final void layout(N n) {
        if (n == null) {
            return;
        }
        Collection<N> collection = this.scene.getNodes();
        ArrayList<N> arrayList = new ArrayList<N>(collection);
        HashSet hashSet = new HashSet();
        Node node = new Node(n, hashSet);
        arrayList.removeAll(hashSet);
        if (this.vertical) {
            node.allocateHorizontally();
            node.resolveVertically(this.originX, this.originY);
        } else {
            node.allocateVertically();
            node.resolveHorizontally(this.originX, this.originY);
        }
        HashMap<N, Point> hashMap = new HashMap<N, Point>();
        node.upload(hashMap);
        for (N object : arrayList) {
            Point point = new Point();
            hashMap.put(object, point);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.scene.findWidget(entry.getKey()).setPreferredLocation((Point)entry.getValue());
        }
    }

    protected Collection<N> resolveChildren(N n) {
        Collection<E> collection = this.scene.findNodeEdges(n, true, false);
        HashSet<N> hashSet = new HashSet<N>();
        for (E e : collection) {
            hashSet.add(this.scene.getEdgeTarget(e));
        }
        return hashSet;
    }

    protected void performGraphLayout(UniversalGraph universalGraph) {
        Collection<N> collection = this.scene.getNodes();
        ArrayList<N> arrayList = new ArrayList<N>();
        for (Object object : collection) {
            Collection<E> collection2 = this.scene.findNodeEdges(object, false, true);
            if (collection2 != null && collection2.size() != 0) continue;
            arrayList.add(object);
        }
        for (Object object : arrayList) {
            this.layout(object);
        }
    }

    protected void performNodesLayout(UniversalGraph universalGraph, Collection collection) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private class Node {
        private N node;
        private ArrayList<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(N n, HashSet<N> hashSet) {
            this.node = n;
            hashSet.add(n);
            Collection collection = TreeGraphLayout.this.resolveChildren(n);
            this.children = new ArrayList();
            for (Object n2 : collection) {
                if (hashSet.contains(n2)) continue;
                this.children.add(new Node(n2, hashSet));
            }
        }

        private int allocateHorizontally() {
            Widget widget = TreeGraphLayout.this.scene.findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int n, int n2) {
            this.point = new Point(n + this.totalSpace / 2, n2 - this.relativeBounds.y);
            n += (this.totalSpace - this.space) / 2;
            n2 += this.relativeBounds.height + TreeGraphLayout.this.verticalGap;
            for (Node node : this.children) {
                node.resolveVertically(n, n2);
                n += node.totalSpace + TreeGraphLayout.this.horizontalGap;
            }
        }

        private int allocateVertically() {
            Widget widget = TreeGraphLayout.this.scene.findWidget(this.node);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayout.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int n, int n2) {
            this.point = new Point(n - this.relativeBounds.x, n2 + this.totalSpace / 2);
            n += this.relativeBounds.width + TreeGraphLayout.this.horizontalGap;
            n2 += (this.totalSpace - this.space) / 2;
            for (Node node : this.children) {
                node.resolveHorizontally(n, n2);
                n2 += node.totalSpace + TreeGraphLayout.this.verticalGap;
            }
        }

        private void upload(HashMap<N, Point> hashMap) {
            hashMap.put(this.node, this.point);
            for (Node node : this.children) {
                node.upload(hashMap);
            }
        }
    }
}

