/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractImageBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.JreUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxResources;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class LinuxAppBundler
extends AbstractImageBundler {
    private static final ResourceBundle I18N;
    protected static final String LINUX_BUNDLER_PREFIX;
    private static final String EXECUTABLE_NAME = "JavaAppLauncher";
    private static final String LIBRARY_NAME = "libpackager.so";
    public static final BundlerParamInfo<File> ICON_PNG;
    public static final BundlerParamInfo<URL> RAW_EXECUTABLE_URL;
    public static final BundlerParamInfo<JreUtils.Rule[]> LINUX_JRE_RULES;
    public static final BundlerParamInfo<RelativeFileSet> LINUX_RUNTIME;

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            return this.doValidate(map);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    boolean doValidate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        if (!System.getProperty("os.name").toLowerCase().startsWith("linux")) {
            throw new UnsupportedPlatformException();
        }
        this.imageBundleValidation(map);
        if (RAW_EXECUTABLE_URL.fetchFrom(map) == null) {
            throw new ConfigException(I18N.getString("error.no-linux-resources"), I18N.getString("error.no-linux-resources.advice"));
        }
        this.testRuntime(LINUX_RUNTIME.fetchFrom(map), new String[]{"lib/[^/]+/[^/]+/libjvm.so", "lib/rt.jar"});
        if (((Boolean)StandardBundlerParam.USE_FX_PACKAGING.fetchFrom(map)).booleanValue()) {
            this.testRuntime(LINUX_RUNTIME.fetchFrom(map), new String[]{"lib/ext/jfxrt.jar", "lib/jfxrt.jar"});
        }
        return true;
    }

    public static File getRootDir(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
    }

    public static String getLauncherName(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map);
    }

    public static String getLauncherCfgName(Map<String, ? super Object> map) {
        return "app/" + (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".cfg";
    }

    File doBundle(Map<String, ? super Object> map, File file, boolean bl) {
        HashMap<String, ? super Object> hashMap = new HashMap<String, Object>(map);
        try {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            File file2 = LinuxAppBundler.getRootDir(file, map);
            IOUtils.deleteRecursive(file2);
            file2.mkdirs();
            if (!bl) {
                Log.info(MessageFormat.format(I18N.getString("message.creating-bundle-location"), file2.getAbsolutePath()));
            }
            File file3 = new File(file2, "runtime");
            File file4 = new File(file2, "app");
            file4.mkdirs();
            this.createLauncherForEntryPoint(map, file2);
            IOUtils.copyFromURL(LinuxResources.class.getResource(LIBRARY_NAME), new File(file2, LIBRARY_NAME));
            List list = (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map);
            for (Map map2 : list) {
                HashMap<String, ? super Object> hashMap2 = new HashMap<String, Object>(hashMap);
                hashMap2.putAll(map2);
                this.createLauncherForEntryPoint(hashMap2, file2);
            }
            this.copyRuntime(map, file3);
            this.copyApplication(map, file4);
            return file2;
        }
        catch (IOException iOException) {
            Log.info("Exception: " + iOException);
            Log.debug(iOException);
            return null;
        }
    }

    private void createLauncherForEntryPoint(Map<String, ? super Object> map, File file) throws IOException {
        File file2 = new File(file, LinuxAppBundler.getLauncherName(map));
        IOUtils.copyFromURL(RAW_EXECUTABLE_URL.fetchFrom(map), file2);
        file2.setExecutable(true, false);
        file2.setWritable(true, true);
        if (((String)LAUNCHER_CFG_FORMAT.fetchFrom(map)).equals("prop")) {
            this.writeCfgFile(map, file);
        } else {
            this.writeCfgFile(map, new File(file, LinuxAppBundler.getLauncherCfgName(map)), this.getRuntimeLocation(map));
        }
    }

    private void copyApplication(Map<String, ? super Object> map, File file) throws IOException {
        List list = (List)StandardBundlerParam.APP_RESOURCES_LIST.fetchFrom(map);
        if (list == null) {
            throw new RuntimeException("Null app resources?");
        }
        for (RelativeFileSet relativeFileSet : list) {
            if (relativeFileSet == null) {
                throw new RuntimeException("Null app resources?");
            }
            File file2 = relativeFileSet.getBaseDirectory();
            for (String string : relativeFileSet.getIncludedFiles()) {
                IOUtils.copyFile(new File(file2, string), new File(file, string));
            }
        }
    }

    private String getRuntimeLocation(Map<String, ? super Object> map) {
        if (LINUX_RUNTIME.fetchFrom(map) == null) {
            return "";
        }
        return "$APPDIR/runtime";
    }

    private void writeCfgFile(Map<String, ? super Object> map, File file) throws FileNotFoundException {
        Map.Entry entry3;
        File file2 = new File(file, LinuxAppBundler.getLauncherCfgName(map));
        file2.delete();
        PrintStream printStream = new PrintStream(file2);
        printStream.println("app.runtime=" + this.getRuntimeLocation(map));
        printStream.println("app.mainjar=" + ((RelativeFileSet)StandardBundlerParam.MAIN_JAR.fetchFrom(map)).getIncludedFiles().iterator().next());
        printStream.println("app.version=" + (String)StandardBundlerParam.VERSION.fetchFrom(map));
        printStream.println("app.mainclass=" + ((String)StandardBundlerParam.MAIN_CLASS.fetchFrom(map)).replaceAll("\\.", "/"));
        StringBuilder stringBuilder = new StringBuilder();
        for (String object22 : ((String)StandardBundlerParam.CLASSPATH.fetchFrom(map)).split("[ ;:]+")) {
            stringBuilder.append(object22);
            stringBuilder.append(":");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        printStream.println("app.classpath=" + stringBuilder.toString());
        List list = (List)StandardBundlerParam.JVM_OPTIONS.fetchFrom(map);
        int n = 1;
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            String string = (String)object3.next();
            printStream.println("jvmarg." + n + "=" + string);
            ++n;
        }
        object3 = (Map)StandardBundlerParam.JVM_PROPERTIES.fetchFrom(map);
        for (Map.Entry entry2 : object3.entrySet()) {
            printStream.println("jvmarg." + n + "=-D" + (String)entry2.getKey() + "=" + (String)entry2.getValue());
            ++n;
        }
        String string = (String)StandardBundlerParam.PRELOADER_CLASS.fetchFrom(map);
        if (string != null) {
            printStream.println("jvmarg." + n + "=-Djavafx.preloader=" + string);
        }
        printStream.println("app.preferences.id=" + (String)StandardBundlerParam.PREFERENCES_ID.fetchFrom(map));
        printStream.println("app.identifier=" + (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map));
        Map map2 = (Map)StandardBundlerParam.USER_JVM_OPTIONS.fetchFrom(map);
        n = 1;
        for (Map.Entry entry3 : map2.entrySet()) {
            if (entry3.getKey() == null || entry3.getValue() == null) {
                Log.info(I18N.getString("message.jvm-user-arg-is-null"));
            } else {
                printStream.println("jvmuserarg." + n + ".name=" + (String)entry3.getKey());
                printStream.println("jvmuserarg." + n + ".value=" + (String)entry3.getValue());
            }
            ++n;
        }
        List list2 = (List)StandardBundlerParam.ARGUMENTS.fetchFrom(map);
        n = 1;
        entry3 = list2.iterator();
        while (entry3.hasNext()) {
            String string2 = (String)entry3.next();
            printStream.println("arg." + n + "=" + string2);
            ++n;
        }
        printStream.close();
    }

    private void copyRuntime(Map<String, ? super Object> map, File file) throws IOException {
        RelativeFileSet relativeFileSet = LINUX_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            return;
        }
        file.mkdirs();
        File file2 = relativeFileSet.getBaseDirectory();
        Set<String> set = relativeFileSet.getIncludedFiles();
        for (String string : set) {
            IOUtils.copyFile(new File(file2, string), new File(file, string));
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "linux.app";
    }

    @Override
    public String getBundleType() {
        return "IMAGE";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        return LinuxAppBundler.getAppBundleParameters();
    }

    public static Collection<BundlerParamInfo<?>> getAppBundleParameters() {
        return Arrays.asList(StandardBundlerParam.APP_NAME, StandardBundlerParam.APP_RESOURCES, StandardBundlerParam.ARGUMENTS, StandardBundlerParam.CLASSPATH, StandardBundlerParam.JVM_OPTIONS, StandardBundlerParam.JVM_PROPERTIES, LINUX_RUNTIME, StandardBundlerParam.MAIN_CLASS, StandardBundlerParam.MAIN_JAR, StandardBundlerParam.PREFERENCES_ID, StandardBundlerParam.PRELOADER_CLASS, StandardBundlerParam.USER_JVM_OPTIONS, StandardBundlerParam.VERSION);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.doBundle(map, file, false);
    }

    @Override
    protected String getCacheLocation(Map<String, ? super Object> map) {
        return "$CACHEDIR/";
    }

    @Override
    public void extractRuntimeFlags(Map<String, ? super Object> map) {
        if (map.containsKey(".runtime.autodetect")) {
            return;
        }
        map.put(".runtime.autodetect", "attempted");
        RelativeFileSet relativeFileSet = LINUX_RUNTIME.fetchFrom(map);
        if (relativeFileSet == null) {
            map.put(".runtime.autodetect", "systemjre");
        } else {
            String string;
            File file = relativeFileSet.getBaseDirectory();
            File file2 = new File(file, "bin/java");
            ProcessBuilder processBuilder = new ProcessBuilder(file2.getAbsolutePath(), "-version");
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (PrintStream printStream = new PrintStream(byteArrayOutputStream);){
                    IOUtils.exec(processBuilder, Log.isDebug(), true, printStream);
                }
                string = byteArrayOutputStream.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                map.put(".runtime.autodetect", "failed");
                return;
            }
            AbstractImageBundler.extractFlagsFromVersion(map, string);
            map.put(".runtime.autodetect", "succeeded");
        }
    }

    private static /* synthetic */ RelativeFileSet lambda$static$140(String string, Map map) {
        return JreUtils.extractJreAsRelativeFileSet(string, LINUX_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ RelativeFileSet lambda$static$139(Map map) {
        return JreUtils.extractJreAsRelativeFileSet(System.getProperty("java.home"), LINUX_JRE_RULES.fetchFrom(map));
    }

    private static /* synthetic */ JreUtils.Rule[] lambda$static$138(String string, Map map) {
        return null;
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

