/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public final class UntrustedCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String ALGORITHM_KEY = "Algorithm";
    private static final Properties props = new Properties();
    private static final String algorithm;

    private static String stripColons(Object object) {
        String string = (String)object;
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ':') continue;
            if (i != n) {
                cArray[n] = cArray[i];
            }
            ++n;
        }
        if (n == cArray.length) {
            return string;
        }
        return new String(cArray, 0, n);
    }

    public static boolean isUntrusted(X509Certificate x509Certificate) {
        String string;
        if (algorithm == null) {
            return false;
        }
        if (x509Certificate instanceof X509CertImpl) {
            string = ((X509CertImpl)x509Certificate).getFingerprint(algorithm);
        } else {
            try {
                string = new X509CertImpl(x509Certificate.getEncoded()).getFingerprint(algorithm);
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        return props.containsKey(string);
    }

    private UntrustedCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                block15: {
                    File file = new File(System.getProperty("java.home"), "lib/security/blacklisted.certs");
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        props.load(fileInputStream);
                        for (Map.Entry entry : props.entrySet()) {
                            entry.setValue(UntrustedCertificates.stripColons(entry.getValue()));
                        }
                    }
                    catch (IOException iOException) {
                        if (debug == null) break block15;
                        debug.println("Error parsing blacklisted.certs");
                    }
                }
                return null;
            }
        });
        algorithm = props.getProperty(ALGORITHM_KEY);
    }
}

