/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.IntegerInput;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartConfigurer;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;

public class MultiChartConfigurer
extends ChartConfigurer {
    @Override
    protected FLRChartDescriptor getChartDescriptor() {
        return (FLRChartDescriptor)((Object)this.getComponentSettings().getChildObject("chartDescriptor", FLRChartDescriptor.class));
    }

    @Override
    protected IInput createInput() {
        TabFolderInput tfi = new TabFolderInput();
        tfi.addInput(this.createGeneral());
        tfi.addInput(this.createLeftYAxis());
        tfi.addInput(this.createRightYAxis());
        tfi.addInput(this.createXAxis());
        tfi.addInput(this.createGroupBy());
        return tfi;
    }

    @Override
    protected IInput createGeneral() {
        CompositeInput ci = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE);
        ci.addInput(InputFactory.createRole(new Role[0]));
        ci.addInput(this.createChartHeight());
        return ci;
    }

    private IInput createChartHeight() {
        return new IntegerInput("chartHeight", Messages.MULTI_CHART_CONFIGURER_CHART_HEIGHT_LABEL, Integer.valueOf(5), Integer.valueOf(500));
    }

    protected IInput createGroupBy() {
        CompositeInput input = new CompositeInput(Messages.MULTI_CHART_CONFIGURER_GROUP_BY_LABEL, "groupBy");
        input.addInput(InputFactory.createEventTypeInput(this.getServiceLocator()));
        input.addInput(InputFactory.createAttributeWithRepositoryForKey(this.getServiceLocator(), "eventTypes", false));
        input.addInput(InputFactory.createUnit(false));
        input.addInput(this.createWidth());
        input.addInput(InputFactory.createOperativeSetEnabled());
        input.addInput(InputFactory.createConstrainWithFilter());
        return input;
    }

    private IInput createWidth() {
        return new IntegerInput("width", Messages.MULTI_CHART_CONFIGURER_WIDTH_LABEL, Integer.valueOf(0), Integer.valueOf(1000));
    }
}

