/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class UIThread
implements Visitable {
    private final List<UITrack> m_tracks = new ArrayList<UITrack>();
    private final RenderInfo m_renderInfo = new RenderInfo();
    private final IMCThread m_thread;
    private final ITrackGroup m_threadTrackGroup;

    public UIThread(IMCThread t, ITrackGroup threadTrackGroup) {
        this.m_thread = t;
        this.m_threadTrackGroup = threadTrackGroup;
        this.m_renderInfo.setSampler(new CompositeRangeSampler());
    }

    public void addTracks(Collection<UITrack> uiTracks) {
        this.m_tracks.addAll(uiTracks);
        Collections.sort(this.m_tracks);
    }

    public Long getThreadId() {
        return this.m_thread.getThreadId();
    }

    public String getThreadName() {
        return this.m_thread.getThreadName();
    }

    public String getThreadState() {
        return this.m_thread.getThreadState();
    }

    public ITimeRange getRange() {
        return this.m_threadTrackGroup.getRange();
    }

    public RenderInfo getRenderInfo() {
        return this.m_renderInfo;
    }

    public List<UITrack> getTracks() {
        return this.m_tracks;
    }

    public String toString() {
        return this.getThreadName();
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    public String getThreadGroup() {
        return this.m_thread.getThreadGroup();
    }

    public IMCThread getThread() {
        return this.m_thread;
    }
}

