/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.configuration.DataSeriesInput;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class FlightRecorderChartMasterDetailInput
extends DataSeriesInput {
    public FlightRecorderChartMasterDetailInput(IServiceLocator serviceLocator, FLRChartDescriptor chartDescriptor, YAxisDescriptor axiDescriptor, String name) {
        super(serviceLocator, (ChartDescriptor)chartDescriptor, axiDescriptor, name);
    }

    protected List<IInput> createDataSourceInputs(IServiceLocator sl) {
        ArrayList<IInput> inputs = new ArrayList<IInput>();
        inputs.add(InputFactory.createEventTypeInput(sl));
        inputs.add(InputFactory.createAttributeWithRepositoryForKey(sl, "eventTypes", false));
        inputs.add(InputFactory.createOperativeSet());
        return inputs;
    }

    protected List<DataSeriesDescriptor> createNew(Shell shell) {
        Object[] selectedObjects;
        BrowseForEventAttributeWizard wizardPage = new BrowseForEventAttributeWizard(this.getServiceLocator(), 2, false, null);
        wizardPage.setNumericAttributesOnly(true);
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)wizardPage);
        dialog.setWidthConstraint(600, 800);
        dialog.setHeightConstraint(600, Integer.MAX_VALUE);
        if (dialog.open() == 0 && (selectedObjects = wizardPage.getSelection().toArray()).length > 0) {
            ArrayList<DataSeriesDescriptor> list = new ArrayList<DataSeriesDescriptor>();
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                list.add(this.createDataSeriesDescriptor((IField)selectedObject));
                ++n2;
            }
            return list;
        }
        return new ArrayList<DataSeriesDescriptor>();
    }

    private DataSeriesDescriptor createDataSeriesDescriptor(IField field) {
        DataSeriesDescriptor dsd = new DataSeriesDescriptor();
        dsd.setName(field.getName());
        dsd.setDescription(field.getDescription());
        EventTypeDescriptorRepository etr = new EventTypeDescriptorRepository();
        EventTypeDescriptor etd = new EventTypeDescriptor();
        etd.setIdentifier(field.getEventTypePath());
        etd.setName(field.getEventTypePath());
        etr.getDescriptors().add(etd);
        FLRDescriptorToolkit.setEventTypeRepository(dsd, etr);
        FLRDescriptorToolkit.setYDataSource(dsd, field.getIdentifier());
        return dsd;
    }
}

