/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.components.ui.base.AbstractUIConfigurer;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputControl;
import com.jrockit.mc.components.ui.settings.TabFolderInput;
import com.jrockit.mc.flightrecorder.ui.components.chart.FlightRecorderChartMasterDetailInput;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.greychart.ui.model.YAxisDescriptor;
import com.jrockit.mc.greychart.ui.views.configuration.ChartGeneralInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ChartConfigurer
extends AbstractUIConfigurer {
    protected FLRChartDescriptor getChartDescriptor() {
        return (FLRChartDescriptor)((Object)this.getComponentSettings().getChildObject("chartDescriptor", FLRChartDescriptor.class));
    }

    public Control createPart(Composite parent) {
        return new InputControl(parent, this.getStatusProvider(), (Object)this.getChartDescriptor(), this.createInput());
    }

    protected IInput createInput() {
        TabFolderInput tab = new TabFolderInput();
        tab.addInput(this.createGeneral());
        tab.addInput(this.createLeftYAxis());
        tab.addInput(this.createRightYAxis());
        tab.addInput(this.createXAxis());
        return tab;
    }

    protected IInput createRightYAxis() {
        return this.createTabs(Messages.CHART_CONFIGURER_RIGHT_YAXIS_NAME, "rightYaxis", this.createYAxis(this.getChartDescriptor().getRightYAxis()));
    }

    protected IInput createLeftYAxis() {
        return this.createTabs(Messages.CHART_CONFIGURER_LEFT_YAXIS_NAME, "leftYaxis", this.createYAxis(this.getChartDescriptor().getLeftYAxis()));
    }

    protected IInput createTabs(String name, String key, IInput axisInput) {
        TabFolderInput tfi = new TabFolderInput(name);
        tfi.addInput(this.createChartGeneral(key));
        tfi.addInput(axisInput);
        return tfi;
    }

    protected IInput createChartGeneral(String key) {
        return new ChartGeneralInput(key);
    }

    protected IInput createGeneral() {
        CompositeInput ci = new CompositeInput(Messages.COMPONENT_GENERAL_TITLE, null);
        ci.addInput(InputFactory.createRole(new Role[0]));
        ci.addInput((IInput)new BooleanInput("lockDataSeries", Messages.CHART_CONFIGURER_LOCK_DATA_SERIES));
        return ci;
    }

    protected IInput createXAxis() {
        CompositeInput ci = new CompositeInput(Messages.CHART_CONFIGURER_XAXIS_NAME, "xAxis");
        ci.addInput(InputFactory.createAttributeWithRepository(this.getServiceLocator(), this.createEventTypeDescriptor(), false));
        ci.addInput((IInput)new BooleanInput("showTickMarks", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_SHOW_TICK_MARKS_INPUT_TEXT));
        ci.addInput((IInput)new BooleanInput("showGridLines", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_SHOW_GRID_LINES_INPUT_TEXT));
        ci.addInput((IInput)new BooleanInput("extrapolateMissing", Messages.CHART_COMPONENT_CONFIGURATION_X_AXIS_EXTRAPOLATE_MISSING_DATA_INPUT_TEXT));
        ci.addInput(InputFactory.createUnit(false));
        ci.addInput(InputFactory.createTitle());
        ci.addInput(InputFactory.createVisible());
        return ci;
    }

    protected EventTypeDescriptorRepository createEventTypeDescriptor() {
        EventTypeDescriptorRepository etr = new EventTypeDescriptorRepository();
        EventTypeDescriptor etd = new EventTypeDescriptor();
        etd.setIdentifier("*");
        etr.getDescriptors().add(etd);
        return etr;
    }

    protected IInput createYAxis(YAxisDescriptor yAxisDescriptor) {
        return new FlightRecorderChartMasterDetailInput(this.getServiceLocator(), this.getChartDescriptor(), yAxisDescriptor, Messages.CHART_CONFIGURER_DATA_SERIES_NAME);
    }
}

