/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.aggregators;

import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorType;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import java.util.HashSet;
import java.util.Set;

public class UniqueValues
implements IAggregator {
    private Set<Object> values = new HashSet<Object>();
    private final int MAX_SIZE = 10000;

    @Override
    public void add(Object value) {
        if (this.values == null || this.values.size() >= 10000) {
            this.values = null;
        } else {
            this.values.add(value);
        }
    }

    @Override
    public Object getResult() {
        if (this.values == null) {
            return null;
        }
        if (this.values.size() == 1) {
            return this.values.iterator().next();
        }
        return this.values;
    }

    @Override
    public AggregatorType getCompatibleWith() {
        return AggregatorType.STRING;
    }

    @Override
    public void addFromAggregator(IAggregator aggregator) {
        UniqueValues v = (UniqueValues)aggregator;
        if (v.values != null && this.values != null) {
            for (Object o : v.values) {
                this.add(o);
            }
        }
    }
}

