/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.common;

import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.Values;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.IValues;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import com.jrockit.mc.flightrecorder.util.OrderByEndTime;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SimpleView
implements IView {
    private ITimeRange m_range = new TimeRange(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    private Set<IEventType> m_eventTypes = new HashSet<IEventType>();
    private IEventFilter m_filter = AlwaysTrueFilter.getInstance();
    private EventOrder m_sortOrder = EventOrder.ANY;
    private Expansion m_expanded = Expansion.NORMAL;
    private Iterable<IEvent> m_events;
    private final IValues<?> m_values;

    public SimpleView(Iterable<IEvent> events) {
        this.m_events = events;
        this.m_values = new Values((IView)this);
    }

    public SimpleView() {
        this(new ArrayList<IEvent>());
    }

    public void setEvents(Iterable<IEvent> events) {
        this.m_events = events;
    }

    public void setSpan(ITimeRange range) {
        this.m_range = range;
    }

    public Iterator<IEvent> iterator() {
        if (this.m_sortOrder != EventOrder.ANY || this.m_expanded == Expansion.EXPANDED) {
            ArrayList<IEvent> events = new ArrayList<IEvent>();
            Iterator<IEvent> it = this.m_events.iterator();
            while (it.hasNext()) {
                events.add(it.next());
            }
            Collections.sort(events, OrderByEndTime.getInstance());
            EventStorage holder = new EventStorage(events.toArray(new IEvent[events.size()]));
            return holder.iterator(this.createEventTypeFilter(this.m_eventTypes, this.m_filter), this.m_range, this.m_expanded);
        }
        return new InternalIterator(this.m_events, this.m_range, this.m_eventTypes, this.m_filter);
    }

    private IEventFilter createEventTypeFilter(final Set<IEventType> types, final IEventFilter filter) {
        return new IEventFilter(){

            public boolean accept(IEvent event) {
                return types.contains(event.getEventType()) && filter.accept(event);
            }
        };
    }

    public ITimeRange getRange() {
        return this.m_range;
    }

    public void setRange(ITimeRange range) {
        this.m_range = range;
    }

    public Collection<IEventType> getEventTypes() {
        return this.m_eventTypes;
    }

    public void setEventTypes(Collection<IEventType> types) {
        this.m_eventTypes = new HashSet<IEventType>(types);
    }

    public void setFilter(IEventFilter filter) {
        this.m_filter = filter;
    }

    public IEventFilter getFilter() {
        return this.m_filter;
    }

    public EventOrder getOrder() {
        return this.m_sortOrder;
    }

    public void setOrder(EventOrder order) {
        this.m_sortOrder = order;
    }

    public void setExpansion(Expansion expanded) {
        this.m_expanded = expanded;
    }

    public void setTracks(Collection<ITrack> tracks) {
        throw new UnsupportedOperationException();
    }

    public Collection<ITrack> getTracks() {
        throw new UnsupportedOperationException();
    }

    public IValues<?> getValues() {
        return this.m_values;
    }

    public IView copy() {
        SimpleView view = new SimpleView(this.m_events);
        view.setExpansion(this.m_expanded);
        view.setOrder(this.getOrder());
        view.setFilter(this.getFilter());
        view.setRange(this.getRange());
        return view;
    }

    private static class InternalIterator
    implements Iterator<IEvent> {
        private final Iterator<IEvent> m_it;
        private final long start;
        private final long end;
        private final Set<IEventType> m_eventTypes;
        private final IEventFilter m_filter;
        private IEvent m_event;

        InternalIterator(Iterable<IEvent> events, ITimeRange range, Set<IEventType> types, IEventFilter filter) {
            this.m_it = events.iterator();
            this.start = range.getStartTimestamp();
            this.end = range.getEndTimestamp();
            this.m_eventTypes = types;
            this.m_filter = filter;
            this.skipForward();
        }

        @Override
        public boolean hasNext() {
            return this.m_event != null;
        }

        @Override
        public IEvent next() {
            if (this.m_event != null) {
                IEvent e = this.m_event;
                this.skipForward();
                return e;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported by iterator");
        }

        public void skipForward() {
            while (this.m_it.hasNext()) {
                IEvent event = this.m_it.next();
                if (event.getStartTimestamp() < this.start || event.getStartTimestamp() > this.end || !this.m_eventTypes.contains(event.getEventType()) || !this.m_filter.accept(event)) continue;
                this.m_event = event;
                return;
            }
            this.m_event = null;
        }
    }
}

