/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.common.IMemberAccessor;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.DelegatingLabelProvider;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import org.eclipse.jface.viewers.ColumnLabelProvider;

public class ColumnsToolkit {
    private static final ColumnLabelProvider DEFAULT_LP = new ColumnLabelProvider(){

        public String getText(Object element) {
            return element == null ? "" : TypeHandling.getValueString((Object)element);
        }

        public String getToolTipText(Object e) {
            return e instanceof IQuantity ? ((IQuantity)e).displayUsing("verbose") : null;
        }
    };

    public static <U> IColumn createColumn(String name, String id, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createColumn(name, null, id, DEFAULT_LP, cellExtractor);
    }

    public static <U> IColumn createColumn(String name, String description, String id, ColumnLabelProvider cellLabelProvider, IMemberAccessor<?, U> cellAccessor) {
        return new Column(name, description, id, new DelegatingLabelProvider(cellLabelProvider, cellAccessor));
    }

    public static <U> IColumn createComparedColumn(String name, String id, ColumnLabelProvider cellLabelProvider, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createComparedColumn(name, null, id, 131072, cellLabelProvider, cellExtractor);
    }

    public static <U> IColumn createComparedColumn(String name, String id, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createComparedColumn(name, id, 131072, cellExtractor);
    }

    public static <U> IColumn createComparedColumn(String name, String id, int style, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createComparedColumn(name, null, id, style, cellExtractor);
    }

    public static <U> IColumn createComparedColumn(String name, String description, String id, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createComparedColumn(name, description, id, 131072, cellExtractor);
    }

    public static <U> IColumn createComparedColumn(String name, String description, String id, int style, IMemberAccessor<?, U> cellExtractor) {
        return ColumnsToolkit.createComparedColumn(name, description, id, style, DEFAULT_LP, cellExtractor);
    }

    public static <U> IColumn createComparedColumn(String name, String description, String id, int style, ColumnLabelProvider cellLabelProvider, IMemberAccessor<?, U> cellAccessor) {
        IMemberAccessor<?, U> ca = cellAccessor;
        return new Column(name, description, id, style, new DelegatingLabelProvider(cellLabelProvider, ca), ca);
    }
}

